/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.model;

import ch.rasc.bsoncodec.model.CodecInfo;
import ch.rasc.bsoncodec.model.InstanceField;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.squareup.javapoet.TypeName;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.lang.model.element.TypeElement;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableCodecInfo
extends CodecInfo {
    private final TypeElement valueType;
    private final TypeName codecType;
    private final ImmutableSet<InstanceField> instanceFields;
    private final boolean needRegistryField;

    private ImmutableCodecInfo(TypeElement valueType, TypeName codecType, Iterable<? extends InstanceField> instanceFields, boolean needRegistryField) {
        this.valueType = (TypeElement)Preconditions.checkNotNull((Object)valueType, (Object)"valueType");
        this.codecType = (TypeName)Preconditions.checkNotNull((Object)codecType, (Object)"codecType");
        this.instanceFields = ImmutableSet.copyOf(instanceFields);
        this.needRegistryField = needRegistryField;
    }

    @Override
    public TypeElement valueType() {
        return this.valueType;
    }

    @Override
    public TypeName codecType() {
        return this.codecType;
    }

    public ImmutableSet<InstanceField> instanceFields() {
        return this.instanceFields;
    }

    @Override
    public boolean needRegistryField() {
        return this.needRegistryField;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCodecInfo && this.equalTo((ImmutableCodecInfo)another);
    }

    private boolean equalTo(ImmutableCodecInfo another) {
        return this.valueType.equals(another.valueType) && this.codecType.equals((Object)another.codecType) && this.instanceFields.equals(another.instanceFields) && this.needRegistryField == another.needRegistryField;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.valueType.hashCode();
        h = h * 17 + this.codecType.hashCode();
        h = h * 17 + this.instanceFields.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.needRegistryField);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CodecInfo").add("valueType", (Object)this.valueType).add("codecType", (Object)this.codecType).add("instanceFields", this.instanceFields).add("needRegistryField", this.needRegistryField).toString();
    }

    public static ImmutableCodecInfo of(TypeElement valueType, TypeName codecType, Set<InstanceField> instanceFields, boolean needRegistryField) {
        return ImmutableCodecInfo.of(valueType, codecType, instanceFields, needRegistryField);
    }

    public static ImmutableCodecInfo of(TypeElement valueType, TypeName codecType, Iterable<? extends InstanceField> instanceFields, boolean needRegistryField) {
        return new ImmutableCodecInfo(valueType, codecType, instanceFields, needRegistryField);
    }
}

