/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen;

import ch.rasc.bsoncodec.Util;
import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.codegen.CompoundCodeGen;
import ch.rasc.bsoncodec.model.FieldModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.bson.BsonType;

public class CollectionCodeGen
extends CompoundCodeGen {
    private TypeMirror implementationType;
    private static Map<String, Class<?>> defaultCollImpl = new HashMap();
    private static Set<String> permitNullCollections = new HashSet<String>();

    public CollectionCodeGen(CompoundCodeGen parent, TypeMirror type) {
        super(parent, type);
    }

    public void setImplementationType(TypeMirror implementationType) {
        this.implementationType = implementationType;
    }

    protected TypeName getImplementationType() {
        if (this.implementationType == null) {
            Class<?> impl = this.getDefaultImplementation();
            if (impl != null) {
                return ClassName.get(impl);
            }
            return ClassName.get((TypeElement)((TypeElement)Util.typeUtils.asElement(this.getType())));
        }
        return ClassName.get((TypeElement)((TypeElement)Util.typeUtils.asElement(this.implementationType)));
    }

    @Override
    public void addEncodeStatements(CodeGeneratorContext ctx) {
        FieldModel field = ctx.field();
        MethodSpec.Builder builder = ctx.builder();
        if (!field.disableEncodeNullCheck() && !this.hasParent()) {
            builder.beginControlFlow("if ($L != null)", new Object[]{ctx.getter()});
        }
        if (!field.storeEmptyCollection()) {
            builder.beginControlFlow("if (!$L.isEmpty())", new Object[]{ctx.getter()});
        }
        if (!this.hasParent()) {
            builder.addStatement("writer.writeName($S)", new Object[]{field.name()});
        }
        TypeMirror childType = this.getChildCodeGen().getType();
        builder.addStatement("writer.writeStartArray()", new Object[0]).beginControlFlow("for ($T $L : $L)", new Object[]{childType, Character.valueOf(ctx.getLoopVar()), ctx.getter()});
        boolean permittNullElements = this.permitNullElements();
        if (!field.disableEncodeNullCheck() && permittNullElements) {
            builder.beginControlFlow("if ($L != null)", new Object[]{Character.valueOf(ctx.getLoopVar())});
        }
        this.getChildCodeGen().addEncodeStatements(ctx.createEncodeChildContext(String.valueOf(ctx.getLoopVar())));
        if (!field.disableEncodeNullCheck() && permittNullElements) {
            builder.nextControlFlow("else", new Object[0]).addStatement("writer.writeNull()", new Object[0]);
            builder.endControlFlow();
        }
        builder.endControlFlow().addStatement("writer.writeEndArray()", new Object[0]);
        if (!field.storeEmptyCollection()) {
            builder.endControlFlow();
        }
        if (!field.disableEncodeNullCheck() && !this.hasParent()) {
            if (field.storeNullValue()) {
                builder.nextControlFlow("else", new Object[0]).addStatement("writer.writeNull($S)", new Object[]{field.name()});
            }
            builder.endControlFlow();
        }
    }

    @Override
    public void addDecodeStatements(CodeGeneratorContext ctx) {
        FieldModel field = ctx.field();
        MethodSpec.Builder builder = ctx.builder();
        char lv = ctx.getLoopVar();
        CodeGeneratorContext childCtx = ctx.createDecodeChildContext(lv + ".add(%s)");
        if (!field.disableDecodeNullCheck() && !this.hasParent()) {
            builder.beginControlFlow("if (bsonType != $T.NULL)", new Object[]{BsonType.class});
        }
        builder.addStatement("reader.readStartArray()", new Object[0]);
        TypeMirror childType = this.getChildCodeGen().getType();
        if (Util.isSameType(this.getType(), EnumSet.class)) {
            builder.addStatement("$T $L = $T.noneOf($T.class)", new Object[]{this.getType(), Character.valueOf(lv), EnumSet.class, childType});
        } else {
            builder.addStatement("$T $L = new $T<>()", new Object[]{this.getType(), Character.valueOf(lv), this.getImplementationType()});
        }
        builder.beginControlFlow("while ((bsonType = reader.readBsonType()) != $T.END_OF_DOCUMENT)", new Object[]{BsonType.class});
        boolean permittNullElements = this.permitNullElements();
        if (permittNullElements) {
            builder.beginControlFlow("if (bsonType != $T.NULL)", new Object[]{BsonType.class});
        }
        this.getChildCodeGen().addDecodeStatements(childCtx);
        if (permittNullElements) {
            builder.nextControlFlow("else", new Object[0]).addStatement("reader.readNull()", new Object[0]);
            builder.addStatement(lv + ".add(null)", new Object[0]);
            builder.endControlFlow();
        }
        builder.endControlFlow().addStatement("reader.readEndArray()", new Object[0]);
        builder.addStatement(ctx.setter("$L"), new Object[]{Character.valueOf(lv)});
        if (!field.disableDecodeNullCheck() && !this.hasParent()) {
            builder.nextControlFlow("else", new Object[0]).addStatement("reader.readNull()", new Object[0]);
            if (!ctx.field().disableSetNullStatement()) {
                this.getChildCodeGen().addSetNullStatements(ctx);
            }
            builder.endControlFlow();
        }
    }

    private static void addToDefaultCollImpl(Class<?> interfaceClass, Class<?> implClass) {
        defaultCollImpl.put(Util.erasure(Util.elementUtils.getTypeElement(interfaceClass.getCanonicalName()).asType()).toString(), implClass);
    }

    private Class<?> getDefaultImplementation() {
        return defaultCollImpl.get(Util.erasure(this.getType()).toString());
    }

    private boolean permitNullElements() {
        return permitNullCollections.contains(this.getImplementationType().toString());
    }

    static {
        CollectionCodeGen.addToDefaultCollImpl(Collection.class, ArrayList.class);
        CollectionCodeGen.addToDefaultCollImpl(List.class, ArrayList.class);
        CollectionCodeGen.addToDefaultCollImpl(Set.class, LinkedHashSet.class);
        CollectionCodeGen.addToDefaultCollImpl(SortedSet.class, TreeSet.class);
        CollectionCodeGen.addToDefaultCollImpl(NavigableSet.class, TreeSet.class);
        CollectionCodeGen.addToDefaultCollImpl(BlockingDeque.class, LinkedBlockingDeque.class);
        CollectionCodeGen.addToDefaultCollImpl(BlockingQueue.class, LinkedBlockingQueue.class);
        CollectionCodeGen.addToDefaultCollImpl(Deque.class, LinkedBlockingDeque.class);
        CollectionCodeGen.addToDefaultCollImpl(Queue.class, LinkedBlockingQueue.class);
        CollectionCodeGen.addToDefaultCollImpl(TransferQueue.class, LinkedTransferQueue.class);
        permitNullCollections.addAll(Arrays.asList(ArrayList.class.getCanonicalName(), LinkedList.class.getCanonicalName(), HashSet.class.getCanonicalName(), HashMap.class.getCanonicalName(), LinkedHashSet.class.getCanonicalName(), LinkedHashMap.class.getCanonicalName(), TreeSet.class.getCanonicalName(), TreeMap.class.getCanonicalName(), IdentityHashMap.class.getCanonicalName(), EnumMap.class.getCanonicalName(), CopyOnWriteArrayList.class.getCanonicalName(), CopyOnWriteArraySet.class.getCanonicalName()));
    }
}

