/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec;

import ch.rasc.bsoncodec.model.CodecInfo;
import ch.rasc.bsoncodec.model.InstanceField;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

public class ProviderCodeGenerator {
    private final String fullyQualifiedName;
    private final List<CodecInfo> codecs;
    private final Set<InstanceField> instanceFields;

    ProviderCodeGenerator(String fullyQualifiedName, List<CodecInfo> codecs) {
        this.fullyQualifiedName = fullyQualifiedName;
        this.codecs = codecs;
        this.instanceFields = codecs.stream().flatMap(c -> c.instanceFields().stream()).collect(Collectors.toCollection(TreeSet::new));
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public void generate(Appendable appendable) throws IOException {
        String className;
        String packageName;
        int pos = this.fullyQualifiedName.lastIndexOf(".");
        if (pos > 0) {
            packageName = this.fullyQualifiedName.substring(0, pos);
            className = this.fullyQualifiedName.substring(pos + 1);
        } else {
            packageName = "";
            className = this.fullyQualifiedName;
        }
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)className);
        classBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        classBuilder.addSuperinterface(CodecProvider.class);
        this.addInstanceFields(classBuilder);
        this.addConstructor(classBuilder);
        this.addGetMethod(classBuilder);
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)classBuilder.build()).build();
        javaFile.writeTo(appendable);
    }

    private void addConstructor(TypeSpec.Builder classBuilder) {
        if (this.instanceFields.isEmpty()) {
            return;
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        constructor.addStatement(this.instanceFields.stream().map(s -> "new $T()").collect(Collectors.joining(", ", "this(", ")")), this.instanceFields.stream().map(InstanceField::type).collect(Collectors.toList()).toArray());
        classBuilder.addMethod(constructor.build());
        constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (InstanceField instanceField : this.instanceFields) {
            constructor.addParameter(instanceField.type(), instanceField.name(), new Modifier[]{Modifier.FINAL});
            constructor.addStatement("this.$N = $N", new Object[]{instanceField.name(), instanceField.name()});
        }
        classBuilder.addMethod(constructor.build());
    }

    private void addInstanceFields(TypeSpec.Builder classBuilder) {
        for (InstanceField instanceField : this.instanceFields) {
            FieldSpec field = FieldSpec.builder((TypeName)instanceField.type(), (String)instanceField.name(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            classBuilder.addField(field);
        }
    }

    private void addGetMethod(TypeSpec.Builder classBuilder) {
        TypeVariableName typeVariable = TypeVariableName.get((String)"T");
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"get").addTypeVariable(typeVariable).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Codec.class), (TypeName[])new TypeName[]{typeVariable})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{typeVariable}), "clazz", new Modifier[]{Modifier.FINAL}).addParameter(CodecRegistry.class, "registry", new Modifier[]{Modifier.FINAL});
        for (CodecInfo codec : this.codecs) {
            builder.beginControlFlow("if (clazz.equals($T.class))", new Object[]{codec.valueType()});
            if (codec.needRegistryField()) {
                if (codec.instanceFields().isEmpty()) {
                    builder.addStatement("return (Codec<T>) new $T(registry)", new Object[]{codec.codecType()});
                } else {
                    builder.addStatement("return (Codec<T>) new $T(registry, $N)", new Object[]{codec.codecType(), codec.instanceFields().stream().map(i -> i.name()).collect(Collectors.joining(", "))});
                }
            } else if (codec.instanceFields().isEmpty()) {
                builder.addStatement("return (Codec<T>) new $T()", new Object[]{codec.codecType()});
            } else {
                builder.addStatement("return (Codec<T>) new $T($N)", new Object[]{codec.codecType(), codec.instanceFields().stream().map(i -> i.name()).collect(Collectors.joining(", "))});
            }
            builder.endControlFlow();
        }
        builder.addStatement("return null", new Object[0]);
        classBuilder.addMethod(builder.build());
    }
}

