package ch.rasc.bsoncodec.model;

import ch.rasc.bsoncodec.codegen.CodeGen;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.VariableElement;

/**
 * Immutable implementation of {@link FieldModel}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFieldModel.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "FieldModel"})
@Immutable
public final class ImmutableFieldModel extends FieldModel {
  private final VariableElement varEl;
  private final String name;
  private final int order;
  private final @Nullable String customCodecName;
  private final CodeGen codeGen;
  private final boolean storeNullValue;
  private final boolean storeEmptyCollection;
  private final boolean disableEncodeNullCheck;
  private final boolean disableDecodeNullCheck;
  private final boolean disableSetNullStatement;
  private final @Nullable IdModel idModel;
  private final String methodNameSet;
  private final String methodNameGet;

  private ImmutableFieldModel(ImmutableFieldModel.Builder builder) {
    this.varEl = builder.varEl;
    this.order = builder.order;
    this.customCodecName = builder.customCodecName;
    this.codeGen = builder.codeGen;
    this.idModel = builder.idModel;
    this.methodNameSet = builder.methodNameSet;
    this.methodNameGet = builder.methodNameGet;
    if (builder.name != null) {
      initShim.name(builder.name);
    }
    if (builder.storeNullValueIsSet()) {
      initShim.storeNullValue(builder.storeNullValue);
    }
    if (builder.storeEmptyCollectionIsSet()) {
      initShim.storeEmptyCollection(builder.storeEmptyCollection);
    }
    if (builder.disableEncodeNullCheckIsSet()) {
      initShim.disableEncodeNullCheck(builder.disableEncodeNullCheck);
    }
    if (builder.disableDecodeNullCheckIsSet()) {
      initShim.disableDecodeNullCheck(builder.disableDecodeNullCheck);
    }
    if (builder.disableSetNullStatementIsSet()) {
      initShim.disableSetNullStatement(builder.disableSetNullStatement);
    }
    this.name = initShim.name();
    this.storeNullValue = initShim.storeNullValue();
    this.storeEmptyCollection = initShim.storeEmptyCollection();
    this.disableEncodeNullCheck = initShim.disableEncodeNullCheck();
    this.disableDecodeNullCheck = initShim.disableDecodeNullCheck();
    this.disableSetNullStatement = initShim.disableSetNullStatement();
    this.initShim = null;
  }

  private ImmutableFieldModel(
      VariableElement varEl,
      String name,
      int order,
      @Nullable String customCodecName,
      CodeGen codeGen,
      boolean storeNullValue,
      boolean storeEmptyCollection,
      boolean disableEncodeNullCheck,
      boolean disableDecodeNullCheck,
      boolean disableSetNullStatement,
      @Nullable IdModel idModel,
      String methodNameSet,
      String methodNameGet) {
    this.varEl = varEl;
    this.name = name;
    this.order = order;
    this.customCodecName = customCodecName;
    this.codeGen = codeGen;
    this.storeNullValue = storeNullValue;
    this.storeEmptyCollection = storeEmptyCollection;
    this.disableEncodeNullCheck = disableEncodeNullCheck;
    this.disableDecodeNullCheck = disableDecodeNullCheck;
    this.disableSetNullStatement = disableSetNullStatement;
    this.idModel = idModel;
    this.methodNameSet = methodNameSet;
    this.methodNameGet = methodNameGet;
    initShim.name(name);
    initShim.storeNullValue(storeNullValue);
    initShim.storeEmptyCollection(storeEmptyCollection);
    initShim.disableEncodeNullCheck(disableEncodeNullCheck);
    initShim.disableDecodeNullCheck(disableDecodeNullCheck);
    initShim.disableSetNullStatement(disableSetNullStatement);
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String name;
    private byte nameStage;

    String name() {
      if (nameStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nameStage == STAGE_UNINITIALIZED) {
        nameStage = STAGE_INITIALIZING;
        this.name = Preconditions.checkNotNull(ImmutableFieldModel.super.name(), "name");
        nameStage = STAGE_INITIALIZED;
      }
      return name;
    }

    String name(String value) {
      this.name = value;
      nameStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean storeNullValue;
    private byte storeNullValueStage;

    boolean storeNullValue() {
      if (storeNullValueStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (storeNullValueStage == STAGE_UNINITIALIZED) {
        storeNullValueStage = STAGE_INITIALIZING;
        this.storeNullValue = ImmutableFieldModel.super.storeNullValue();
        storeNullValueStage = STAGE_INITIALIZED;
      }
      return storeNullValue;
    }

    boolean storeNullValue(boolean value) {
      this.storeNullValue = value;
      storeNullValueStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean storeEmptyCollection;
    private byte storeEmptyCollectionStage;

    boolean storeEmptyCollection() {
      if (storeEmptyCollectionStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (storeEmptyCollectionStage == STAGE_UNINITIALIZED) {
        storeEmptyCollectionStage = STAGE_INITIALIZING;
        this.storeEmptyCollection = ImmutableFieldModel.super.storeEmptyCollection();
        storeEmptyCollectionStage = STAGE_INITIALIZED;
      }
      return storeEmptyCollection;
    }

    boolean storeEmptyCollection(boolean value) {
      this.storeEmptyCollection = value;
      storeEmptyCollectionStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean disableEncodeNullCheck;
    private byte disableEncodeNullCheckStage;

    boolean disableEncodeNullCheck() {
      if (disableEncodeNullCheckStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disableEncodeNullCheckStage == STAGE_UNINITIALIZED) {
        disableEncodeNullCheckStage = STAGE_INITIALIZING;
        this.disableEncodeNullCheck = ImmutableFieldModel.super.disableEncodeNullCheck();
        disableEncodeNullCheckStage = STAGE_INITIALIZED;
      }
      return disableEncodeNullCheck;
    }

    boolean disableEncodeNullCheck(boolean value) {
      this.disableEncodeNullCheck = value;
      disableEncodeNullCheckStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean disableDecodeNullCheck;
    private byte disableDecodeNullCheckStage;

    boolean disableDecodeNullCheck() {
      if (disableDecodeNullCheckStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disableDecodeNullCheckStage == STAGE_UNINITIALIZED) {
        disableDecodeNullCheckStage = STAGE_INITIALIZING;
        this.disableDecodeNullCheck = ImmutableFieldModel.super.disableDecodeNullCheck();
        disableDecodeNullCheckStage = STAGE_INITIALIZED;
      }
      return disableDecodeNullCheck;
    }

    boolean disableDecodeNullCheck(boolean value) {
      this.disableDecodeNullCheck = value;
      disableDecodeNullCheckStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean disableSetNullStatement;
    private byte disableSetNullStatementStage;

    boolean disableSetNullStatement() {
      if (disableSetNullStatementStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disableSetNullStatementStage == STAGE_UNINITIALIZED) {
        disableSetNullStatementStage = STAGE_INITIALIZING;
        this.disableSetNullStatement = ImmutableFieldModel.super.disableSetNullStatement();
        disableSetNullStatementStage = STAGE_INITIALIZED;
      }
      return disableSetNullStatement;
    }

    boolean disableSetNullStatement(boolean value) {
      this.disableSetNullStatement = value;
      disableSetNullStatementStage = STAGE_INITIALIZED;
      return value;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = Lists.newArrayList();
      if (nameStage == STAGE_INITIALIZING) attributes.add("name");
      if (storeNullValueStage == STAGE_INITIALIZING) attributes.add("storeNullValue");
      if (storeEmptyCollectionStage == STAGE_INITIALIZING) attributes.add("storeEmptyCollection");
      if (disableEncodeNullCheckStage == STAGE_INITIALIZING) attributes.add("disableEncodeNullCheck");
      if (disableDecodeNullCheckStage == STAGE_INITIALIZING) attributes.add("disableDecodeNullCheck");
      if (disableSetNullStatementStage == STAGE_INITIALIZING) attributes.add("disableSetNullStatement");
      return "Cannot build FieldModel, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code varEl} attribute
   */
  @Override
  public VariableElement varEl() {
    return varEl;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return initShim != null
        ? initShim.name()
        : name;
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @Override
  public int order() {
    return order;
  }

  /**
   * @return The value of the {@code customCodecName} attribute
   */
  @Override
  public @Nullable String customCodecName() {
    return customCodecName;
  }

  /**
   * @return The value of the {@code codeGen} attribute
   */
  @Override
  public CodeGen codeGen() {
    return codeGen;
  }

  /**
   * @return The value of the {@code storeNullValue} attribute
   */
  @Override
  public boolean storeNullValue() {
    return initShim != null
        ? initShim.storeNullValue()
        : storeNullValue;
  }

  /**
   * @return The value of the {@code storeEmptyCollection} attribute
   */
  @Override
  public boolean storeEmptyCollection() {
    return initShim != null
        ? initShim.storeEmptyCollection()
        : storeEmptyCollection;
  }

  /**
   * @return The value of the {@code disableEncodeNullCheck} attribute
   */
  @Override
  public boolean disableEncodeNullCheck() {
    return initShim != null
        ? initShim.disableEncodeNullCheck()
        : disableEncodeNullCheck;
  }

  /**
   * @return The value of the {@code disableDecodeNullCheck} attribute
   */
  @Override
  public boolean disableDecodeNullCheck() {
    return initShim != null
        ? initShim.disableDecodeNullCheck()
        : disableDecodeNullCheck;
  }

  /**
   * @return The value of the {@code disableSetNullStatement} attribute
   */
  @Override
  public boolean disableSetNullStatement() {
    return initShim != null
        ? initShim.disableSetNullStatement()
        : disableSetNullStatement;
  }

  /**
   * @return The value of the {@code idModel} attribute
   */
  @Override
  public @Nullable IdModel idModel() {
    return idModel;
  }

  /**
   * @return The value of the {@code methodNameSet} attribute
   */
  @Override
  public String methodNameSet() {
    return methodNameSet;
  }

  /**
   * @return The value of the {@code methodNameGet} attribute
   */
  @Override
  public String methodNameGet() {
    return methodNameGet;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#varEl() varEl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for varEl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withVarEl(VariableElement value) {
    if (this.varEl == value) return this;
    VariableElement newValue = Preconditions.checkNotNull(value, "varEl");
    return new ImmutableFieldModel(
        newValue,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#name() name} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withName(String value) {
    if (this.name == value) return this;
    String newValue = Preconditions.checkNotNull(value, "name");
    return new ImmutableFieldModel(
        this.varEl,
        newValue,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#order() order} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for order
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withOrder(int value) {
    if (this.order == value) return this;
    int newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        newValue,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#customCodecName() customCodecName} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for customCodecName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withCustomCodecName(@Nullable String value) {
    if (this.customCodecName == value) return this;
    @Nullable String newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        newValue,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#codeGen() codeGen} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for codeGen
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withCodeGen(CodeGen value) {
    if (this.codeGen == value) return this;
    CodeGen newValue = Preconditions.checkNotNull(value, "codeGen");
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        newValue,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#storeNullValue() storeNullValue} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for storeNullValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withStoreNullValue(boolean value) {
    if (this.storeNullValue == value) return this;
    boolean newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        newValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#storeEmptyCollection() storeEmptyCollection} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for storeEmptyCollection
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withStoreEmptyCollection(boolean value) {
    if (this.storeEmptyCollection == value) return this;
    boolean newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        newValue,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#disableEncodeNullCheck() disableEncodeNullCheck} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disableEncodeNullCheck
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withDisableEncodeNullCheck(boolean value) {
    if (this.disableEncodeNullCheck == value) return this;
    boolean newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        newValue,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#disableDecodeNullCheck() disableDecodeNullCheck} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disableDecodeNullCheck
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withDisableDecodeNullCheck(boolean value) {
    if (this.disableDecodeNullCheck == value) return this;
    boolean newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        newValue,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#disableSetNullStatement() disableSetNullStatement} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disableSetNullStatement
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withDisableSetNullStatement(boolean value) {
    if (this.disableSetNullStatement == value) return this;
    boolean newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        newValue,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#idModel() idModel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for idModel (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withIdModel(@Nullable IdModel value) {
    if (this.idModel == value) return this;
    @Nullable IdModel newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        newValue,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#methodNameSet() methodNameSet} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for methodNameSet
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withMethodNameSet(String value) {
    if (this.methodNameSet == value) return this;
    String newValue = Preconditions.checkNotNull(value, "methodNameSet");
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        newValue,
        this.methodNameGet);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldModel#methodNameGet() methodNameGet} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for methodNameGet
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withMethodNameGet(String value) {
    if (this.methodNameGet == value) return this;
    String newValue = Preconditions.checkNotNull(value, "methodNameGet");
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFieldModel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFieldModel
        && equalTo((ImmutableFieldModel) another);
  }

  private boolean equalTo(ImmutableFieldModel another) {
    return varEl.equals(another.varEl)
        && name.equals(another.name)
        && order == another.order
        && Objects.equal(customCodecName, another.customCodecName)
        && codeGen.equals(another.codeGen)
        && storeNullValue == another.storeNullValue
        && storeEmptyCollection == another.storeEmptyCollection
        && disableEncodeNullCheck == another.disableEncodeNullCheck
        && disableDecodeNullCheck == another.disableDecodeNullCheck
        && disableSetNullStatement == another.disableSetNullStatement
        && Objects.equal(idModel, another.idModel)
        && methodNameSet.equals(another.methodNameSet)
        && methodNameGet.equals(another.methodNameGet);
  }

  /**
   * Computes a hash code from attributes: {@code varEl}, {@code name}, {@code order}, {@code customCodecName}, {@code codeGen}, {@code storeNullValue}, {@code storeEmptyCollection}, {@code disableEncodeNullCheck}, {@code disableDecodeNullCheck}, {@code disableSetNullStatement}, {@code idModel}, {@code methodNameSet}, {@code methodNameGet}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + varEl.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + order;
    h = h * 17 + Objects.hashCode(customCodecName);
    h = h * 17 + codeGen.hashCode();
    h = h * 17 + Booleans.hashCode(storeNullValue);
    h = h * 17 + Booleans.hashCode(storeEmptyCollection);
    h = h * 17 + Booleans.hashCode(disableEncodeNullCheck);
    h = h * 17 + Booleans.hashCode(disableDecodeNullCheck);
    h = h * 17 + Booleans.hashCode(disableSetNullStatement);
    h = h * 17 + Objects.hashCode(idModel);
    h = h * 17 + methodNameSet.hashCode();
    h = h * 17 + methodNameGet.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FieldModel...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FieldModel")
        .add("varEl", varEl)
        .add("name", name)
        .add("order", order)
        .add("customCodecName", customCodecName)
        .add("codeGen", codeGen)
        .add("storeNullValue", storeNullValue)
        .add("storeEmptyCollection", storeEmptyCollection)
        .add("disableEncodeNullCheck", disableEncodeNullCheck)
        .add("disableDecodeNullCheck", disableDecodeNullCheck)
        .add("disableSetNullStatement", disableSetNullStatement)
        .add("idModel", idModel)
        .add("methodNameSet", methodNameSet)
        .add("methodNameGet", methodNameGet)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FieldModel} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FieldModel instance
   */
  public static ImmutableFieldModel copyOf(FieldModel instance) {
    if (instance instanceof ImmutableFieldModel) {
      return (ImmutableFieldModel) instance;
    }
    return ImmutableFieldModel.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFieldModel ImmutableFieldModel}.
   * @return A new ImmutableFieldModel builder
   */
  public static ImmutableFieldModel.Builder builder() {
    return new ImmutableFieldModel.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFieldModel ImmutableFieldModel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VAR_EL = 0x1L;
    private static final long INIT_BIT_ORDER = 0x2L;
    private static final long INIT_BIT_CODE_GEN = 0x4L;
    private static final long INIT_BIT_METHOD_NAME_SET = 0x8L;
    private static final long INIT_BIT_METHOD_NAME_GET = 0x10L;
    private static final long OPT_BIT_STORE_NULL_VALUE = 0x1L;
    private static final long OPT_BIT_STORE_EMPTY_COLLECTION = 0x2L;
    private static final long OPT_BIT_DISABLE_ENCODE_NULL_CHECK = 0x4L;
    private static final long OPT_BIT_DISABLE_DECODE_NULL_CHECK = 0x8L;
    private static final long OPT_BIT_DISABLE_SET_NULL_STATEMENT = 0x10L;
    private long initBits = 0x1f;
    private long optBits;

    private @Nullable VariableElement varEl;
    private @Nullable String name;
    private int order;
    private @Nullable String customCodecName;
    private @Nullable CodeGen codeGen;
    private boolean storeNullValue;
    private boolean storeEmptyCollection;
    private boolean disableEncodeNullCheck;
    private boolean disableDecodeNullCheck;
    private boolean disableSetNullStatement;
    private @Nullable IdModel idModel;
    private @Nullable String methodNameSet;
    private @Nullable String methodNameGet;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@link FieldModel} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FieldModel instance) {
      Preconditions.checkNotNull(instance, "instance");
      varEl(instance.varEl());
      name(instance.name());
      order(instance.order());
      @Nullable String customCodecNameValue = instance.customCodecName();
      if (customCodecNameValue != null) {
        customCodecName(customCodecNameValue);
      }
      codeGen(instance.codeGen());
      storeNullValue(instance.storeNullValue());
      storeEmptyCollection(instance.storeEmptyCollection());
      disableEncodeNullCheck(instance.disableEncodeNullCheck());
      disableDecodeNullCheck(instance.disableDecodeNullCheck());
      disableSetNullStatement(instance.disableSetNullStatement());
      @Nullable IdModel idModelValue = instance.idModel();
      if (idModelValue != null) {
        idModel(idModelValue);
      }
      methodNameSet(instance.methodNameSet());
      methodNameGet(instance.methodNameGet());
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#varEl() varEl} attribute.
     * @param varEl The value for varEl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder varEl(VariableElement varEl) {
      this.varEl = Preconditions.checkNotNull(varEl, "varEl");
      initBits &= ~INIT_BIT_VAR_EL;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#name() name} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FieldModel#name() name}.</em>
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#order() order} attribute.
     * @param order The value for order 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder order(int order) {
      this.order = order;
      initBits &= ~INIT_BIT_ORDER;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#customCodecName() customCodecName} attribute.
     * @param customCodecName The value for customCodecName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder customCodecName(@Nullable String customCodecName) {
      this.customCodecName = customCodecName;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#codeGen() codeGen} attribute.
     * @param codeGen The value for codeGen 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder codeGen(CodeGen codeGen) {
      this.codeGen = Preconditions.checkNotNull(codeGen, "codeGen");
      initBits &= ~INIT_BIT_CODE_GEN;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#storeNullValue() storeNullValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FieldModel#storeNullValue() storeNullValue}.</em>
     * @param storeNullValue The value for storeNullValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder storeNullValue(boolean storeNullValue) {
      this.storeNullValue = storeNullValue;
      optBits |= OPT_BIT_STORE_NULL_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#storeEmptyCollection() storeEmptyCollection} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FieldModel#storeEmptyCollection() storeEmptyCollection}.</em>
     * @param storeEmptyCollection The value for storeEmptyCollection 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder storeEmptyCollection(boolean storeEmptyCollection) {
      this.storeEmptyCollection = storeEmptyCollection;
      optBits |= OPT_BIT_STORE_EMPTY_COLLECTION;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#disableEncodeNullCheck() disableEncodeNullCheck} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FieldModel#disableEncodeNullCheck() disableEncodeNullCheck}.</em>
     * @param disableEncodeNullCheck The value for disableEncodeNullCheck 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder disableEncodeNullCheck(boolean disableEncodeNullCheck) {
      this.disableEncodeNullCheck = disableEncodeNullCheck;
      optBits |= OPT_BIT_DISABLE_ENCODE_NULL_CHECK;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#disableDecodeNullCheck() disableDecodeNullCheck} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FieldModel#disableDecodeNullCheck() disableDecodeNullCheck}.</em>
     * @param disableDecodeNullCheck The value for disableDecodeNullCheck 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder disableDecodeNullCheck(boolean disableDecodeNullCheck) {
      this.disableDecodeNullCheck = disableDecodeNullCheck;
      optBits |= OPT_BIT_DISABLE_DECODE_NULL_CHECK;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#disableSetNullStatement() disableSetNullStatement} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FieldModel#disableSetNullStatement() disableSetNullStatement}.</em>
     * @param disableSetNullStatement The value for disableSetNullStatement 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder disableSetNullStatement(boolean disableSetNullStatement) {
      this.disableSetNullStatement = disableSetNullStatement;
      optBits |= OPT_BIT_DISABLE_SET_NULL_STATEMENT;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#idModel() idModel} attribute.
     * @param idModel The value for idModel (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder idModel(@Nullable IdModel idModel) {
      this.idModel = idModel;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#methodNameSet() methodNameSet} attribute.
     * @param methodNameSet The value for methodNameSet 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder methodNameSet(String methodNameSet) {
      this.methodNameSet = Preconditions.checkNotNull(methodNameSet, "methodNameSet");
      initBits &= ~INIT_BIT_METHOD_NAME_SET;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldModel#methodNameGet() methodNameGet} attribute.
     * @param methodNameGet The value for methodNameGet 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder methodNameGet(String methodNameGet) {
      this.methodNameGet = Preconditions.checkNotNull(methodNameGet, "methodNameGet");
      initBits &= ~INIT_BIT_METHOD_NAME_GET;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFieldModel ImmutableFieldModel}.
     * @return An immutable instance of FieldModel
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFieldModel build() throws IllegalStateException {
      checkRequiredAttributes();
      return new ImmutableFieldModel(this);
    }

    private boolean storeNullValueIsSet() {
      return (optBits & OPT_BIT_STORE_NULL_VALUE) != 0;
    }

    private boolean storeEmptyCollectionIsSet() {
      return (optBits & OPT_BIT_STORE_EMPTY_COLLECTION) != 0;
    }

    private boolean disableEncodeNullCheckIsSet() {
      return (optBits & OPT_BIT_DISABLE_ENCODE_NULL_CHECK) != 0;
    }

    private boolean disableDecodeNullCheckIsSet() {
      return (optBits & OPT_BIT_DISABLE_DECODE_NULL_CHECK) != 0;
    }

    private boolean disableSetNullStatementIsSet() {
      return (optBits & OPT_BIT_DISABLE_SET_NULL_STATEMENT) != 0;
    }

    private boolean varElIsSet() {
      return (initBits & INIT_BIT_VAR_EL) == 0;
    }

    private boolean orderIsSet() {
      return (initBits & INIT_BIT_ORDER) == 0;
    }

    private boolean codeGenIsSet() {
      return (initBits & INIT_BIT_CODE_GEN) == 0;
    }

    private boolean methodNameSetIsSet() {
      return (initBits & INIT_BIT_METHOD_NAME_SET) == 0;
    }

    private boolean methodNameGetIsSet() {
      return (initBits & INIT_BIT_METHOD_NAME_GET) == 0;
    }

    private void checkRequiredAttributes() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if (!varElIsSet()) attributes.add("varEl");
      if (!orderIsSet()) attributes.add("order");
      if (!codeGenIsSet()) attributes.add("codeGen");
      if (!methodNameSetIsSet()) attributes.add("methodNameSet");
      if (!methodNameGetIsSet()) attributes.add("methodNameGet");
      return "Cannot build FieldModel, some of required attributes are not set " + attributes;
    }
  }
}
