/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen;

import ch.rasc.bsoncodec.annotation.Id;
import ch.rasc.bsoncodec.codegen.CodeGen;
import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.model.IdModel;
import com.squareup.javapoet.MethodSpec;
import java.util.Base64;
import org.bson.types.ObjectId;

public class ConversionObjectIdCodeGen
implements CodeGen {
    @Override
    public void addEncodeStatements(CodeGeneratorContext ctx) {
        IdModel idModel = ctx.field().idModel();
        MethodSpec.Builder builder = ctx.builder();
        builder.addStatement("$T id", new Object[]{ObjectId.class}).beginControlFlow("if ($L == null)", new Object[]{ctx.getter()}).addStatement("id = ($T)this.$N.generate()", new Object[]{ObjectId.class, idModel.generatorName()});
        if (idModel.conversion() == Id.IdConversion.HEX_OBJECTID) {
            builder.addStatement(ctx.setter("id.toHexString()"), new Object[0]);
        } else if (idModel.conversion() == Id.IdConversion.BASE64_OBJECTID) {
            builder.addStatement(ctx.setter("$T.getUrlEncoder().encodeToString(id.toByteArray())"), new Object[]{Base64.class});
        }
        builder.nextControlFlow("else", new Object[0]);
        if (idModel.conversion() == Id.IdConversion.HEX_OBJECTID) {
            builder.addStatement("id = new $T($L)", new Object[]{ObjectId.class, ctx.getter()});
        } else if (idModel.conversion() == Id.IdConversion.BASE64_OBJECTID) {
            builder.addStatement("id = new $T($T.getUrlDecoder().decode($L))", new Object[]{ObjectId.class, Base64.class, ctx.getter()});
        }
        builder.endControlFlow().addStatement("writer.writeObjectId($S, id)", new Object[]{ctx.field().name()});
    }

    @Override
    public void addDecodeStatements(CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        IdModel idModel = ctx.field().idModel();
        builder.addStatement("$T id = reader.readObjectId()", new Object[]{ObjectId.class});
        if (idModel.conversion() == Id.IdConversion.HEX_OBJECTID) {
            builder.addStatement(ctx.setter("id.toHexString()"), new Object[0]);
        } else if (idModel.conversion() == Id.IdConversion.BASE64_OBJECTID) {
            builder.addStatement(ctx.setter("$T.getUrlEncoder().encodeToString(id.toByteArray())"), new Object[]{Base64.class});
        }
    }
}

