package ch.rasc.bsoncodec.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InstanceField}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableInstanceField.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstanceField"})
@Immutable
public final class ImmutableInstanceField extends InstanceField {
  private final TypeName type;
  private final String name;
  private final @Nullable TypeName codecForClass;
  private final boolean customCodec;

  private ImmutableInstanceField(ImmutableInstanceField.Builder builder) {
    this.type = builder.type;
    this.name = builder.name;
    this.codecForClass = builder.codecForClass;
    this.customCodec = builder.customCodecIsSet()
        ? builder.customCodec
        : super.customCodec();
  }

  private ImmutableInstanceField(
      TypeName type,
      String name,
      @Nullable TypeName codecForClass,
      boolean customCodec) {
    this.type = type;
    this.name = name;
    this.codecForClass = codecForClass;
    this.customCodec = customCodec;
  }

  /**
   * @return value of {@code type} attribute
   */
  @Override
  public TypeName type() {
    return type;
  }

  /**
   * @return value of {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return value of {@code codecForClass} attribute
   */
  @Override
  public @Nullable TypeName codecForClass() {
    return codecForClass;
  }

  /**
   * @return value of {@code customCodec} attribute
   */
  @Override
  public boolean customCodec() {
    return customCodec;
  }

  /**
   * Copy current immutable object by setting value for {@link InstanceField#type() type}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for type
   * @return modified copy of the {@code this} object
   */
  public final ImmutableInstanceField withType(TypeName value) {
    if (this.type == value) return this;
    TypeName newValue = Preconditions.checkNotNull(value);
    return new ImmutableInstanceField(newValue, this.name, this.codecForClass, this.customCodec);
  }

  /**
   * Copy current immutable object by setting value for {@link InstanceField#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final ImmutableInstanceField withName(String value) {
    if (this.name == value) return this;
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableInstanceField(this.type, newValue, this.codecForClass, this.customCodec);
  }

  /**
   * Copy current immutable object by setting value for {@link InstanceField#codecForClass() codecForClass}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for codecForClass, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ImmutableInstanceField withCodecForClass(@Nullable TypeName value) {
    if (this.codecForClass == value) return this;
    @Nullable TypeName newValue = value;
    return new ImmutableInstanceField(this.type, this.name, newValue, this.customCodec);
  }

  /**
   * Copy current immutable object by setting value for {@link InstanceField#customCodec() customCodec}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for customCodec
   * @return modified copy of the {@code this} object
   */
  public final ImmutableInstanceField withCustomCodec(boolean value) {
    if (this.customCodec == value) return this;
    boolean newValue = value;
    return new ImmutableInstanceField(this.type, this.name, this.codecForClass, newValue);
  }

  /**
   * This instance is equal to instances of {@code ImmutableInstanceField} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInstanceField
        && equalTo((ImmutableInstanceField) another);
  }

  private boolean equalTo(ImmutableInstanceField another) {
    return type.equals(another.type)
        && name.equals(another.name)
        && Objects.equal(codecForClass, another.codecForClass)
        && customCodec == another.customCodec;
  }

  /**
   * Computes hash code from attributes: {@code type}, {@code name}, {@code codecForClass}, {@code customCodec}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(codecForClass);
    h = h * 17 + Booleans.hashCode(customCodec);
    return h;
  }

  /**
   * Prints immutable value {@code InstanceField...} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InstanceField")
        .add("type", type)
        .add("name", name)
        .add("codecForClass", codecForClass)
        .add("customCodec", customCodec)
        .toString();
  }

  /**
   * Creates immutable copy of {@link InstanceField}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable InstanceField instance
   */
  public static ImmutableInstanceField copyOf(InstanceField instance) {
    if (instance instanceof ImmutableInstanceField) {
      return (ImmutableInstanceField) instance;
    }
    return ImmutableInstanceField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link ch.rasc.bsoncodec.model.ImmutableInstanceField ImmutableInstanceField}.
   * @return new ImmutableInstanceField builder
   */
  public static ImmutableInstanceField.Builder builder() {
    return new ImmutableInstanceField.Builder();
  }

  /**
   * Builds instances of {@link ch.rasc.bsoncodec.model.ImmutableInstanceField ImmutableInstanceField}.
   * Initialize attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>{@code Builder} is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long OPT_BIT_CUSTOM_CODEC = 0x1L;
    private long initBits = 0x3;
    private long optBits;

    private @Nullable TypeName type;
    private @Nullable String name;
    private @Nullable TypeName codecForClass;
    private boolean customCodec;

    private Builder() {}

    /**
     * Fill builder with attribute values from provided {@link InstanceField} instance.
     * Regular attribute values will be replaced with ones of an instance.
     * Instance's absent optional values will not replace present values.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(InstanceField instance) {
      Preconditions.checkNotNull(instance);
      type(instance.type());
      name(instance.name());
      @Nullable TypeName codecForClassValue = instance.codecForClass();
      if (codecForClassValue != null) {
        codecForClass(codecForClassValue);
      }
      customCodec(instance.customCodec());
      return this;
    }

    /**
     * Initializes value for {@link InstanceField#type() type}.
     * @param type value for type
     * @return {@code this} builder for chained invocation
     */
    public final Builder type(TypeName type) {
      this.type = Preconditions.checkNotNull(type);
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes value for {@link InstanceField#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes value for {@link InstanceField#codecForClass() codecForClass}.
     * @param codecForClass value for codecForClass, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder codecForClass(@Nullable TypeName codecForClass) {
      this.codecForClass = codecForClass;
      return this;
    }

    /**
     * Initializes value for {@link InstanceField#customCodec() customCodec}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link InstanceField#customCodec() customCodec}.</em>
     * @param customCodec value for customCodec
     * @return {@code this} builder for chained invocation
     */
    public final Builder customCodec(boolean customCodec) {
      this.customCodec = customCodec;
      optBits |= OPT_BIT_CUSTOM_CODEC;
      return this;
    }
    /**
     * Builds new {@link ch.rasc.bsoncodec.model.ImmutableInstanceField ImmutableInstanceField}.
     * @return immutable instance of InstanceField
     * @throws exception {@code java.lang.IllegalStateException} if any required attributes are missing
     */
    public ImmutableInstanceField build()
        throws IllegalStateException {
      checkRequiredAttributes(); return new ImmutableInstanceField(this);
    }

    private boolean customCodecIsSet() {
      return (optBits & OPT_BIT_CUSTOM_CODEC) != 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private void checkRequiredAttributes() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if (!typeIsSet()) attributes.add("type");
      if (!nameIsSet()) attributes.add("name");
      return "Cannot build InstanceField, some of required attributes are not set " + attributes;
    }
  }
}
