package ch.rasc.bsoncodec.model;

import ch.rasc.bsoncodec.annotation.Id;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link IdModel}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableIdModel.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "IdModel"})
@Immutable
public final class ImmutableIdModel extends IdModel {
  private final @Nullable String generatorName;
  private final @Nullable Id.IdConversion conversion;
  private final @Nullable String codecName;

  private ImmutableIdModel(
      @Nullable String generatorName,
      @Nullable Id.IdConversion conversion,
      @Nullable String codecName) {
    this.generatorName = generatorName;
    this.conversion = conversion;
    this.codecName = codecName;
  }

  /**
   * @return value of {@code generatorName} attribute
   */
  @Override
  public @Nullable String generatorName() {
    return generatorName;
  }

  /**
   * @return value of {@code conversion} attribute
   */
  @Override
  public @Nullable Id.IdConversion conversion() {
    return conversion;
  }

  /**
   * @return value of {@code codecName} attribute
   */
  @Override
  public @Nullable String codecName() {
    return codecName;
  }

  /**
   * Copy current immutable object by setting value for {@link IdModel#generatorName() generatorName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for generatorName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ImmutableIdModel withGeneratorName(@Nullable String value) {
    if (this.generatorName == value) return this;
    @Nullable String newValue = value;
    return new ImmutableIdModel(newValue, this.conversion, this.codecName);
  }

  /**
   * Copy current immutable object by setting value for {@link IdModel#conversion() conversion}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for conversion, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ImmutableIdModel withConversion(@Nullable Id.IdConversion value) {
    if (this.conversion == value) return this;
    @Nullable Id.IdConversion newValue = value;
    return new ImmutableIdModel(this.generatorName, newValue, this.codecName);
  }

  /**
   * Copy current immutable object by setting value for {@link IdModel#codecName() codecName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for codecName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ImmutableIdModel withCodecName(@Nullable String value) {
    if (this.codecName == value) return this;
    @Nullable String newValue = value;
    return new ImmutableIdModel(this.generatorName, this.conversion, newValue);
  }

  /**
   * This instance is equal to instances of {@code ImmutableIdModel} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIdModel
        && equalTo((ImmutableIdModel) another);
  }

  private boolean equalTo(ImmutableIdModel another) {
    return Objects.equal(generatorName, another.generatorName)
        && Objects.equal(conversion, another.conversion)
        && Objects.equal(codecName, another.codecName);
  }

  /**
   * Computes hash code from attributes: {@code generatorName}, {@code conversion}, {@code codecName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(generatorName);
    h = h * 17 + Objects.hashCode(conversion);
    h = h * 17 + Objects.hashCode(codecName);
    return h;
  }

  /**
   * Prints immutable value {@code IdModel...} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IdModel")
        .add("generatorName", generatorName)
        .add("conversion", conversion)
        .add("codecName", codecName)
        .toString();
  }

  /**
   * Creates immutable copy of {@link IdModel}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable IdModel instance
   */
  public static ImmutableIdModel copyOf(IdModel instance) {
    if (instance instanceof ImmutableIdModel) {
      return (ImmutableIdModel) instance;
    }
    return ImmutableIdModel.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link ch.rasc.bsoncodec.model.ImmutableIdModel ImmutableIdModel}.
   * @return new ImmutableIdModel builder
   */
  public static ImmutableIdModel.Builder builder() {
    return new ImmutableIdModel.Builder();
  }

  /**
   * Builds instances of {@link ch.rasc.bsoncodec.model.ImmutableIdModel ImmutableIdModel}.
   * Initialize attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>{@code Builder} is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String generatorName;
    private @Nullable Id.IdConversion conversion;
    private @Nullable String codecName;

    private Builder() {}

    /**
     * Fill builder with attribute values from provided {@link IdModel} instance.
     * Regular attribute values will be replaced with ones of an instance.
     * Instance's absent optional values will not replace present values.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(IdModel instance) {
      Preconditions.checkNotNull(instance);
      @Nullable String generatorNameValue = instance.generatorName();
      if (generatorNameValue != null) {
        generatorName(generatorNameValue);
      }
      @Nullable Id.IdConversion conversionValue = instance.conversion();
      if (conversionValue != null) {
        conversion(conversionValue);
      }
      @Nullable String codecNameValue = instance.codecName();
      if (codecNameValue != null) {
        codecName(codecNameValue);
      }
      return this;
    }

    /**
     * Initializes value for {@link IdModel#generatorName() generatorName}.
     * @param generatorName value for generatorName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder generatorName(@Nullable String generatorName) {
      this.generatorName = generatorName;
      return this;
    }

    /**
     * Initializes value for {@link IdModel#conversion() conversion}.
     * @param conversion value for conversion, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder conversion(@Nullable Id.IdConversion conversion) {
      this.conversion = conversion;
      return this;
    }

    /**
     * Initializes value for {@link IdModel#codecName() codecName}.
     * @param codecName value for codecName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder codecName(@Nullable String codecName) {
      this.codecName = codecName;
      return this;
    }
    /**
     * Builds new {@link ch.rasc.bsoncodec.model.ImmutableIdModel ImmutableIdModel}.
     * @return immutable instance of IdModel
     * @throws exception {@code java.lang.IllegalStateException} if any required attributes are missing
     */
    public ImmutableIdModel build()
        throws IllegalStateException {
      return new ImmutableIdModel(generatorName, conversion, codecName);
    }
  }
}
