package ch.rasc.bsoncodec.model;

import ch.rasc.bsoncodec.codegen.CodeGen;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.VariableElement;

/**
 * Immutable implementation of {@link FieldModel}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableFieldModel.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "FieldModel"})
@Immutable
public final class ImmutableFieldModel extends FieldModel {
  private final VariableElement varEl;
  private final String name;
  private final int order;
  private final @Nullable String customCodecName;
  private final CodeGen codeGen;
  private final boolean storeNullValue;
  private final boolean storeEmptyCollection;
  private final boolean disableEncodeNullCheck;
  private final boolean disableDecodeNullCheck;
  private final boolean disableSetNullStatement;
  private final @Nullable IdModel idModel;
  private final String methodNameSet;
  private final String methodNameGet;

  private ImmutableFieldModel(ImmutableFieldModel.Builder builder) {
    this.varEl = builder.varEl;
    this.order = builder.order;
    this.customCodecName = builder.customCodecName;
    this.codeGen = builder.codeGen;
    this.idModel = builder.idModel;
    this.methodNameSet = builder.methodNameSet;
    this.methodNameGet = builder.methodNameGet;
    if (builder.name != null) {
      initShim.name(builder.name);
    }
    if (builder.storeNullValueIsSet()) {
      initShim.storeNullValue(builder.storeNullValue);
    }
    if (builder.storeEmptyCollectionIsSet()) {
      initShim.storeEmptyCollection(builder.storeEmptyCollection);
    }
    if (builder.disableEncodeNullCheckIsSet()) {
      initShim.disableEncodeNullCheck(builder.disableEncodeNullCheck);
    }
    if (builder.disableDecodeNullCheckIsSet()) {
      initShim.disableDecodeNullCheck(builder.disableDecodeNullCheck);
    }
    if (builder.disableSetNullStatementIsSet()) {
      initShim.disableSetNullStatement(builder.disableSetNullStatement);
    }
    this.name = initShim.name();
    this.storeNullValue = initShim.storeNullValue();
    this.storeEmptyCollection = initShim.storeEmptyCollection();
    this.disableEncodeNullCheck = initShim.disableEncodeNullCheck();
    this.disableDecodeNullCheck = initShim.disableDecodeNullCheck();
    this.disableSetNullStatement = initShim.disableSetNullStatement();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String name;
    private byte nameStage;

    String name() {
      if (nameStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nameStage == STAGE_UNINITIALIZED) {
        nameStage = STAGE_INITIALIZING;
        this.name = Preconditions.checkNotNull(ImmutableFieldModel.super.name());
        nameStage = STAGE_INITIALIZED;
      }
      return name;
    }

    String name(String value) {
      this.name = value;
      nameStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean storeNullValue;
    private byte storeNullValueStage;

    boolean storeNullValue() {
      if (storeNullValueStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (storeNullValueStage == STAGE_UNINITIALIZED) {
        storeNullValueStage = STAGE_INITIALIZING;
        this.storeNullValue = ImmutableFieldModel.super.storeNullValue();
        storeNullValueStage = STAGE_INITIALIZED;
      }
      return storeNullValue;
    }

    boolean storeNullValue(boolean value) {
      this.storeNullValue = value;
      storeNullValueStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean storeEmptyCollection;
    private byte storeEmptyCollectionStage;

    boolean storeEmptyCollection() {
      if (storeEmptyCollectionStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (storeEmptyCollectionStage == STAGE_UNINITIALIZED) {
        storeEmptyCollectionStage = STAGE_INITIALIZING;
        this.storeEmptyCollection = ImmutableFieldModel.super.storeEmptyCollection();
        storeEmptyCollectionStage = STAGE_INITIALIZED;
      }
      return storeEmptyCollection;
    }

    boolean storeEmptyCollection(boolean value) {
      this.storeEmptyCollection = value;
      storeEmptyCollectionStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean disableEncodeNullCheck;
    private byte disableEncodeNullCheckStage;

    boolean disableEncodeNullCheck() {
      if (disableEncodeNullCheckStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disableEncodeNullCheckStage == STAGE_UNINITIALIZED) {
        disableEncodeNullCheckStage = STAGE_INITIALIZING;
        this.disableEncodeNullCheck = ImmutableFieldModel.super.disableEncodeNullCheck();
        disableEncodeNullCheckStage = STAGE_INITIALIZED;
      }
      return disableEncodeNullCheck;
    }

    boolean disableEncodeNullCheck(boolean value) {
      this.disableEncodeNullCheck = value;
      disableEncodeNullCheckStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean disableDecodeNullCheck;
    private byte disableDecodeNullCheckStage;

    boolean disableDecodeNullCheck() {
      if (disableDecodeNullCheckStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disableDecodeNullCheckStage == STAGE_UNINITIALIZED) {
        disableDecodeNullCheckStage = STAGE_INITIALIZING;
        this.disableDecodeNullCheck = ImmutableFieldModel.super.disableDecodeNullCheck();
        disableDecodeNullCheckStage = STAGE_INITIALIZED;
      }
      return disableDecodeNullCheck;
    }

    boolean disableDecodeNullCheck(boolean value) {
      this.disableDecodeNullCheck = value;
      disableDecodeNullCheckStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean disableSetNullStatement;
    private byte disableSetNullStatementStage;

    boolean disableSetNullStatement() {
      if (disableSetNullStatementStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (disableSetNullStatementStage == STAGE_UNINITIALIZED) {
        disableSetNullStatementStage = STAGE_INITIALIZING;
        this.disableSetNullStatement = ImmutableFieldModel.super.disableSetNullStatement();
        disableSetNullStatementStage = STAGE_INITIALIZED;
      }
      return disableSetNullStatement;
    }

    boolean disableSetNullStatement(boolean value) {
      this.disableSetNullStatement = value;
      disableSetNullStatementStage = STAGE_INITIALIZED;
      return value;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = Lists.newArrayList();;
      if (nameStage == STAGE_INITIALIZING) attributes.add("name");
      if (storeNullValueStage == STAGE_INITIALIZING) attributes.add("storeNullValue");
      if (storeEmptyCollectionStage == STAGE_INITIALIZING) attributes.add("storeEmptyCollection");
      if (disableEncodeNullCheckStage == STAGE_INITIALIZING) attributes.add("disableEncodeNullCheck");
      if (disableDecodeNullCheckStage == STAGE_INITIALIZING) attributes.add("disableDecodeNullCheck");
      if (disableSetNullStatementStage == STAGE_INITIALIZING) attributes.add("disableSetNullStatement");
      return "Cannot build FieldModel, attribute initializers form cycle" + attributes;
    }
  }


  private ImmutableFieldModel(
      VariableElement varEl,
      String name,
      int order,
      @Nullable String customCodecName,
      CodeGen codeGen,
      boolean storeNullValue,
      boolean storeEmptyCollection,
      boolean disableEncodeNullCheck,
      boolean disableDecodeNullCheck,
      boolean disableSetNullStatement,
      @Nullable IdModel idModel,
      String methodNameSet,
      String methodNameGet) {
    this.varEl = varEl;
    this.name = name;
    this.order = order;
    this.customCodecName = customCodecName;
    this.codeGen = codeGen;
    this.storeNullValue = storeNullValue;
    this.storeEmptyCollection = storeEmptyCollection;
    this.disableEncodeNullCheck = disableEncodeNullCheck;
    this.disableDecodeNullCheck = disableDecodeNullCheck;
    this.disableSetNullStatement = disableSetNullStatement;
    this.idModel = idModel;
    this.methodNameSet = methodNameSet;
    this.methodNameGet = methodNameGet;
    this.initShim = null;
  }

  /**
   * @return value of {@code varEl} attribute
   */
  @Override
  public VariableElement varEl() {
    return varEl;
  }

  /**
   * @return value of {@code name} attribute
   */
  @Override
  public String name() {
    return initShim != null
        ? initShim.name()
        : name;
  }

  /**
   * @return value of {@code order} attribute
   */
  @Override
  public int order() {
    return order;
  }

  /**
   * @return value of {@code customCodecName} attribute
   */
  @Override
  public @Nullable String customCodecName() {
    return customCodecName;
  }

  /**
   * @return value of {@code codeGen} attribute
   */
  @Override
  public CodeGen codeGen() {
    return codeGen;
  }

  /**
   * @return value of {@code storeNullValue} attribute
   */
  @Override
  public boolean storeNullValue() {
    return initShim != null
        ? initShim.storeNullValue()
        : storeNullValue;
  }

  /**
   * @return value of {@code storeEmptyCollection} attribute
   */
  @Override
  public boolean storeEmptyCollection() {
    return initShim != null
        ? initShim.storeEmptyCollection()
        : storeEmptyCollection;
  }

  /**
   * @return value of {@code disableEncodeNullCheck} attribute
   */
  @Override
  public boolean disableEncodeNullCheck() {
    return initShim != null
        ? initShim.disableEncodeNullCheck()
        : disableEncodeNullCheck;
  }

  /**
   * @return value of {@code disableDecodeNullCheck} attribute
   */
  @Override
  public boolean disableDecodeNullCheck() {
    return initShim != null
        ? initShim.disableDecodeNullCheck()
        : disableDecodeNullCheck;
  }

  /**
   * @return value of {@code disableSetNullStatement} attribute
   */
  @Override
  public boolean disableSetNullStatement() {
    return initShim != null
        ? initShim.disableSetNullStatement()
        : disableSetNullStatement;
  }

  /**
   * @return value of {@code idModel} attribute
   */
  @Override
  public @Nullable IdModel idModel() {
    return idModel;
  }

  /**
   * @return value of {@code methodNameSet} attribute
   */
  @Override
  public String methodNameSet() {
    return methodNameSet;
  }

  /**
   * @return value of {@code methodNameGet} attribute
   */
  @Override
  public String methodNameGet() {
    return methodNameGet;
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#varEl() varEl}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for varEl
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withVarEl(VariableElement value) {
    if (this.varEl == value) return this;
    VariableElement newValue = Preconditions.checkNotNull(value);
    return new ImmutableFieldModel(
        newValue,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withName(String value) {
    if (this.name == value) return this;
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableFieldModel(
        this.varEl,
        newValue,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#order() order}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for order
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withOrder(int value) {
    if (this.order == value) return this;
    int newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        newValue,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#customCodecName() customCodecName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for customCodecName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withCustomCodecName(@Nullable String value) {
    if (this.customCodecName == value) return this;
    @Nullable String newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        newValue,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#codeGen() codeGen}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for codeGen
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withCodeGen(CodeGen value) {
    if (this.codeGen == value) return this;
    CodeGen newValue = Preconditions.checkNotNull(value);
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        newValue,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#storeNullValue() storeNullValue}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for storeNullValue
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withStoreNullValue(boolean value) {
    if (this.storeNullValue == value) return this;
    boolean newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        newValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#storeEmptyCollection() storeEmptyCollection}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for storeEmptyCollection
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withStoreEmptyCollection(boolean value) {
    if (this.storeEmptyCollection == value) return this;
    boolean newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        newValue,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#disableEncodeNullCheck() disableEncodeNullCheck}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for disableEncodeNullCheck
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withDisableEncodeNullCheck(boolean value) {
    if (this.disableEncodeNullCheck == value) return this;
    boolean newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        newValue,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#disableDecodeNullCheck() disableDecodeNullCheck}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for disableDecodeNullCheck
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withDisableDecodeNullCheck(boolean value) {
    if (this.disableDecodeNullCheck == value) return this;
    boolean newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        newValue,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#disableSetNullStatement() disableSetNullStatement}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for disableSetNullStatement
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withDisableSetNullStatement(boolean value) {
    if (this.disableSetNullStatement == value) return this;
    boolean newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        newValue,
        this.idModel,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#idModel() idModel}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for idModel, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withIdModel(@Nullable IdModel value) {
    if (this.idModel == value) return this;
    @Nullable IdModel newValue = value;
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        newValue,
        this.methodNameSet,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#methodNameSet() methodNameSet}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for methodNameSet
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withMethodNameSet(String value) {
    if (this.methodNameSet == value) return this;
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        newValue,
        this.methodNameGet);
  }

  /**
   * Copy current immutable object by setting value for {@link FieldModel#methodNameGet() methodNameGet}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for methodNameGet
   * @return modified copy of the {@code this} object
   */
  public final ImmutableFieldModel withMethodNameGet(String value) {
    if (this.methodNameGet == value) return this;
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableFieldModel(
        this.varEl,
        this.name,
        this.order,
        this.customCodecName,
        this.codeGen,
        this.storeNullValue,
        this.storeEmptyCollection,
        this.disableEncodeNullCheck,
        this.disableDecodeNullCheck,
        this.disableSetNullStatement,
        this.idModel,
        this.methodNameSet,
        newValue);
  }

  /**
   * This instance is equal to instances of {@code ImmutableFieldModel} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFieldModel
        && equalTo((ImmutableFieldModel) another);
  }

  private boolean equalTo(ImmutableFieldModel another) {
    return varEl.equals(another.varEl)
        && name.equals(another.name)
        && order == another.order
        && Objects.equal(customCodecName, another.customCodecName)
        && codeGen.equals(another.codeGen)
        && storeNullValue == another.storeNullValue
        && storeEmptyCollection == another.storeEmptyCollection
        && disableEncodeNullCheck == another.disableEncodeNullCheck
        && disableDecodeNullCheck == another.disableDecodeNullCheck
        && disableSetNullStatement == another.disableSetNullStatement
        && Objects.equal(idModel, another.idModel)
        && methodNameSet.equals(another.methodNameSet)
        && methodNameGet.equals(another.methodNameGet);
  }

  /**
   * Computes hash code from attributes: {@code varEl}, {@code name}, {@code order}, {@code customCodecName}, {@code codeGen}, {@code storeNullValue}, {@code storeEmptyCollection}, {@code disableEncodeNullCheck}, {@code disableDecodeNullCheck}, {@code disableSetNullStatement}, {@code idModel}, {@code methodNameSet}, {@code methodNameGet}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + varEl.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + order;
    h = h * 17 + Objects.hashCode(customCodecName);
    h = h * 17 + codeGen.hashCode();
    h = h * 17 + Booleans.hashCode(storeNullValue);
    h = h * 17 + Booleans.hashCode(storeEmptyCollection);
    h = h * 17 + Booleans.hashCode(disableEncodeNullCheck);
    h = h * 17 + Booleans.hashCode(disableDecodeNullCheck);
    h = h * 17 + Booleans.hashCode(disableSetNullStatement);
    h = h * 17 + Objects.hashCode(idModel);
    h = h * 17 + methodNameSet.hashCode();
    h = h * 17 + methodNameGet.hashCode();
    return h;
  }

  /**
   * Prints immutable value {@code FieldModel...} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FieldModel")
        .add("varEl", varEl)
        .add("name", name)
        .add("order", order)
        .add("customCodecName", customCodecName)
        .add("codeGen", codeGen)
        .add("storeNullValue", storeNullValue)
        .add("storeEmptyCollection", storeEmptyCollection)
        .add("disableEncodeNullCheck", disableEncodeNullCheck)
        .add("disableDecodeNullCheck", disableDecodeNullCheck)
        .add("disableSetNullStatement", disableSetNullStatement)
        .add("idModel", idModel)
        .add("methodNameSet", methodNameSet)
        .add("methodNameGet", methodNameGet)
        .toString();
  }

  /**
   * Creates immutable copy of {@link FieldModel}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable FieldModel instance
   */
  public static ImmutableFieldModel copyOf(FieldModel instance) {
    if (instance instanceof ImmutableFieldModel) {
      return (ImmutableFieldModel) instance;
    }
    return ImmutableFieldModel.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link ch.rasc.bsoncodec.model.ImmutableFieldModel ImmutableFieldModel}.
   * @return new ImmutableFieldModel builder
   */
  public static ImmutableFieldModel.Builder builder() {
    return new ImmutableFieldModel.Builder();
  }

  /**
   * Builds instances of {@link ch.rasc.bsoncodec.model.ImmutableFieldModel ImmutableFieldModel}.
   * Initialize attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>{@code Builder} is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VAR_EL = 0x1L;
    private static final long INIT_BIT_ORDER = 0x2L;
    private static final long INIT_BIT_CODE_GEN = 0x4L;
    private static final long INIT_BIT_METHOD_NAME_SET = 0x8L;
    private static final long INIT_BIT_METHOD_NAME_GET = 0x10L;
    private static final long OPT_BIT_STORE_NULL_VALUE = 0x1L;
    private static final long OPT_BIT_STORE_EMPTY_COLLECTION = 0x2L;
    private static final long OPT_BIT_DISABLE_ENCODE_NULL_CHECK = 0x4L;
    private static final long OPT_BIT_DISABLE_DECODE_NULL_CHECK = 0x8L;
    private static final long OPT_BIT_DISABLE_SET_NULL_STATEMENT = 0x10L;
    private long initBits = 0x1f;
    private long optBits;

    private @Nullable VariableElement varEl;
    private @Nullable String name;
    private int order;
    private @Nullable String customCodecName;
    private @Nullable CodeGen codeGen;
    private boolean storeNullValue;
    private boolean storeEmptyCollection;
    private boolean disableEncodeNullCheck;
    private boolean disableDecodeNullCheck;
    private boolean disableSetNullStatement;
    private @Nullable IdModel idModel;
    private @Nullable String methodNameSet;
    private @Nullable String methodNameGet;

    private Builder() {}

    /**
     * Fill builder with attribute values from provided {@link FieldModel} instance.
     * Regular attribute values will be replaced with ones of an instance.
     * Instance's absent optional values will not replace present values.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(FieldModel instance) {
      Preconditions.checkNotNull(instance);
      varEl(instance.varEl());
      name(instance.name());
      order(instance.order());
      @Nullable String customCodecNameValue = instance.customCodecName();
      if (customCodecNameValue != null) {
        customCodecName(customCodecNameValue);
      }
      codeGen(instance.codeGen());
      storeNullValue(instance.storeNullValue());
      storeEmptyCollection(instance.storeEmptyCollection());
      disableEncodeNullCheck(instance.disableEncodeNullCheck());
      disableDecodeNullCheck(instance.disableDecodeNullCheck());
      disableSetNullStatement(instance.disableSetNullStatement());
      @Nullable IdModel idModelValue = instance.idModel();
      if (idModelValue != null) {
        idModel(idModelValue);
      }
      methodNameSet(instance.methodNameSet());
      methodNameGet(instance.methodNameGet());
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#varEl() varEl}.
     * @param varEl value for varEl
     * @return {@code this} builder for chained invocation
     */
    public final Builder varEl(VariableElement varEl) {
      this.varEl = Preconditions.checkNotNull(varEl);
      initBits &= ~INIT_BIT_VAR_EL;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#name() name}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link FieldModel#name() name}.</em>
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#order() order}.
     * @param order value for order
     * @return {@code this} builder for chained invocation
     */
    public final Builder order(int order) {
      this.order = order;
      initBits &= ~INIT_BIT_ORDER;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#customCodecName() customCodecName}.
     * @param customCodecName value for customCodecName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder customCodecName(@Nullable String customCodecName) {
      this.customCodecName = customCodecName;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#codeGen() codeGen}.
     * @param codeGen value for codeGen
     * @return {@code this} builder for chained invocation
     */
    public final Builder codeGen(CodeGen codeGen) {
      this.codeGen = Preconditions.checkNotNull(codeGen);
      initBits &= ~INIT_BIT_CODE_GEN;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#storeNullValue() storeNullValue}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link FieldModel#storeNullValue() storeNullValue}.</em>
     * @param storeNullValue value for storeNullValue
     * @return {@code this} builder for chained invocation
     */
    public final Builder storeNullValue(boolean storeNullValue) {
      this.storeNullValue = storeNullValue;
      optBits |= OPT_BIT_STORE_NULL_VALUE;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#storeEmptyCollection() storeEmptyCollection}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link FieldModel#storeEmptyCollection() storeEmptyCollection}.</em>
     * @param storeEmptyCollection value for storeEmptyCollection
     * @return {@code this} builder for chained invocation
     */
    public final Builder storeEmptyCollection(boolean storeEmptyCollection) {
      this.storeEmptyCollection = storeEmptyCollection;
      optBits |= OPT_BIT_STORE_EMPTY_COLLECTION;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#disableEncodeNullCheck() disableEncodeNullCheck}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link FieldModel#disableEncodeNullCheck() disableEncodeNullCheck}.</em>
     * @param disableEncodeNullCheck value for disableEncodeNullCheck
     * @return {@code this} builder for chained invocation
     */
    public final Builder disableEncodeNullCheck(boolean disableEncodeNullCheck) {
      this.disableEncodeNullCheck = disableEncodeNullCheck;
      optBits |= OPT_BIT_DISABLE_ENCODE_NULL_CHECK;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#disableDecodeNullCheck() disableDecodeNullCheck}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link FieldModel#disableDecodeNullCheck() disableDecodeNullCheck}.</em>
     * @param disableDecodeNullCheck value for disableDecodeNullCheck
     * @return {@code this} builder for chained invocation
     */
    public final Builder disableDecodeNullCheck(boolean disableDecodeNullCheck) {
      this.disableDecodeNullCheck = disableDecodeNullCheck;
      optBits |= OPT_BIT_DISABLE_DECODE_NULL_CHECK;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#disableSetNullStatement() disableSetNullStatement}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link FieldModel#disableSetNullStatement() disableSetNullStatement}.</em>
     * @param disableSetNullStatement value for disableSetNullStatement
     * @return {@code this} builder for chained invocation
     */
    public final Builder disableSetNullStatement(boolean disableSetNullStatement) {
      this.disableSetNullStatement = disableSetNullStatement;
      optBits |= OPT_BIT_DISABLE_SET_NULL_STATEMENT;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#idModel() idModel}.
     * @param idModel value for idModel, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder idModel(@Nullable IdModel idModel) {
      this.idModel = idModel;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#methodNameSet() methodNameSet}.
     * @param methodNameSet value for methodNameSet
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodNameSet(String methodNameSet) {
      this.methodNameSet = Preconditions.checkNotNull(methodNameSet);
      initBits &= ~INIT_BIT_METHOD_NAME_SET;
      return this;
    }

    /**
     * Initializes value for {@link FieldModel#methodNameGet() methodNameGet}.
     * @param methodNameGet value for methodNameGet
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodNameGet(String methodNameGet) {
      this.methodNameGet = Preconditions.checkNotNull(methodNameGet);
      initBits &= ~INIT_BIT_METHOD_NAME_GET;
      return this;
    }
    /**
     * Builds new {@link ch.rasc.bsoncodec.model.ImmutableFieldModel ImmutableFieldModel}.
     * @return immutable instance of FieldModel
     * @throws exception {@code java.lang.IllegalStateException} if any required attributes are missing
     */
    public ImmutableFieldModel build()
        throws IllegalStateException {
      checkRequiredAttributes(); return new ImmutableFieldModel(this);
    }

    private boolean storeNullValueIsSet() {
      return (optBits & OPT_BIT_STORE_NULL_VALUE) != 0;
    }

    private boolean storeEmptyCollectionIsSet() {
      return (optBits & OPT_BIT_STORE_EMPTY_COLLECTION) != 0;
    }

    private boolean disableEncodeNullCheckIsSet() {
      return (optBits & OPT_BIT_DISABLE_ENCODE_NULL_CHECK) != 0;
    }

    private boolean disableDecodeNullCheckIsSet() {
      return (optBits & OPT_BIT_DISABLE_DECODE_NULL_CHECK) != 0;
    }

    private boolean disableSetNullStatementIsSet() {
      return (optBits & OPT_BIT_DISABLE_SET_NULL_STATEMENT) != 0;
    }

    private boolean varElIsSet() {
      return (initBits & INIT_BIT_VAR_EL) == 0;
    }

    private boolean orderIsSet() {
      return (initBits & INIT_BIT_ORDER) == 0;
    }

    private boolean codeGenIsSet() {
      return (initBits & INIT_BIT_CODE_GEN) == 0;
    }

    private boolean methodNameSetIsSet() {
      return (initBits & INIT_BIT_METHOD_NAME_SET) == 0;
    }

    private boolean methodNameGetIsSet() {
      return (initBits & INIT_BIT_METHOD_NAME_GET) == 0;
    }

    private void checkRequiredAttributes() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if (!varElIsSet()) attributes.add("varEl");
      if (!orderIsSet()) attributes.add("order");
      if (!codeGenIsSet()) attributes.add("codeGen");
      if (!methodNameSetIsSet()) attributes.add("methodNameSet");
      if (!methodNameGetIsSet()) attributes.add("methodNameGet");
      return "Cannot build FieldModel, some of required attributes are not set " + attributes;
    }
  }
}
