package ch.rasc.bsoncodec.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.squareup.javapoet.TypeName;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.lang.model.element.TypeElement;

/**
 * Immutable implementation of {@link CodecInfo}.
 * <p>
 * Use static factory method to create immutable instances:
 * {@code ImmutableCodecInfo.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "CodecInfo"})
@Immutable
public final class ImmutableCodecInfo extends CodecInfo {
  private final TypeElement valueType;
  private final TypeName codecType;
  private final ImmutableSet<InstanceField> instanceFields;
  private final boolean needRegistryField;

  private ImmutableCodecInfo(
      TypeElement valueType,
      TypeName codecType,
      Iterable<? extends InstanceField> instanceFields,
      boolean needRegistryField) {
    this.valueType = Preconditions.checkNotNull(valueType);
    this.codecType = Preconditions.checkNotNull(codecType);
    this.instanceFields = ImmutableSet.copyOf(instanceFields);
    this.needRegistryField = needRegistryField;
  }

  /**
   * @return value of {@code valueType} attribute
   */
  @Override
  public TypeElement valueType() {
    return valueType;
  }

  /**
   * @return value of {@code codecType} attribute
   */
  @Override
  public TypeName codecType() {
    return codecType;
  }

  /**
   * @return value of {@code instanceFields} attribute
   */
  @Override
  public ImmutableSet<InstanceField> instanceFields() {
    return instanceFields;
  }

  /**
   * @return value of {@code needRegistryField} attribute
   */
  @Override
  public boolean needRegistryField() {
    return needRegistryField;
  }

  /**
   * This instance is equal to instances of {@code ImmutableCodecInfo} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCodecInfo
        && equalTo((ImmutableCodecInfo) another);
  }

  private boolean equalTo(ImmutableCodecInfo another) {
    return valueType.equals(another.valueType)
        && codecType.equals(another.codecType)
        && instanceFields.equals(another.instanceFields)
        && needRegistryField == another.needRegistryField;
  }

  /**
   * Computes hash code from attributes: {@code valueType}, {@code codecType}, {@code instanceFields}, {@code needRegistryField}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + valueType.hashCode();
    h = h * 17 + codecType.hashCode();
    h = h * 17 + instanceFields.hashCode();
    h = h * 17 + Booleans.hashCode(needRegistryField);
    return h;
  }

  /**
   * Prints immutable value {@code CodecInfo...} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CodecInfo")
        .add("valueType", valueType)
        .add("codecType", codecType)
        .add("instanceFields", instanceFields)
        .add("needRegistryField", needRegistryField)
        .toString();
  }

  /**
   * Construct new immutable {@code CodecInfo} instance.
   * @param valueType value for {@code valueType}
   * @param codecType value for {@code codecType}
   * @param instanceFields value for {@code instanceFields}
   * @param needRegistryField value for {@code needRegistryField}
   * @return immutable CodecInfo instance
   */
  public static ImmutableCodecInfo of(TypeElement valueType, TypeName codecType, Set<InstanceField> instanceFields, boolean needRegistryField) {
    return of(valueType, codecType, (Iterable<? extends InstanceField>) instanceFields, needRegistryField);
  }

  /**
   * Construct new immutable {@code CodecInfo} instance.
   * @param valueType value for {@code valueType}
   * @param codecType value for {@code codecType}
   * @param instanceFields value for {@code instanceFields}
   * @param needRegistryField value for {@code needRegistryField}
   * @return immutable CodecInfo instance
   */
  public static ImmutableCodecInfo of(TypeElement valueType, TypeName codecType, Iterable<? extends InstanceField> instanceFields, boolean needRegistryField) {
    return new ImmutableCodecInfo(valueType, codecType, instanceFields, needRegistryField);
  }
}
