/**
 * Copyright 2015-2015 Ralph Schaer <ralphschaer@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.rasc.bsoncodec.codegen.delegate;

import javax.lang.model.type.TypeMirror;

import org.omg.IOP.Codec;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

import ch.rasc.bsoncodec.Util;
import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.model.ImmutableInstanceField;

public class DefaultDelegate implements CodeGeneratorDelegate {

	private static final String CODEC_POSTFIX = "Codec";

	@Override
	public void addEncodeStatements(TypeMirror type, CodeGeneratorContext ctx) {
		String codecFieldName = Util.varName(type.toString()) + CODEC_POSTFIX;
		ctx.builder().addStatement("this.$N.encode(writer, $L, encoderContext)",
				codecFieldName, ctx.getter());

		ctx.instanceFields()
				.add(ImmutableInstanceField.builder().type(ClassName.get(Codec.class))
						.name(codecFieldName).codecForClass(TypeName.get(type)).build());
	}

	@Override
	public void addDecodeStatements(TypeMirror type, CodeGeneratorContext ctx) {
		ctx.builder().addStatement(ctx.setter("this.$N.decode(reader, decoderContext)"),
				Util.varName(type.toString()) + CODEC_POSTFIX);
	}

	@Override
	public boolean accepts(TypeMirror type) {
		return true;
	}

}
