/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.fastdoubleparser.bte;

import ch.randelshofer.fastdoubleparser.bte.ByteTrie;
import java.nio.charset.StandardCharsets;
import java.util.Set;

final class ByteTrieOfOne
implements ByteTrie {
    private final byte[] chars;

    public ByteTrieOfOne(Set<String> set) {
        if (set.size() != 1) {
            throw new IllegalArgumentException("set size must be 1, size=" + set.size());
        }
        this.chars = set.iterator().next().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public int match(byte[] str) {
        return this.match(str, 0, str.length);
    }

    @Override
    public int match(byte[] str, int startIndex, int endIndex) {
        int i;
        int limit = Math.min(endIndex - startIndex, this.chars.length);
        for (i = 0; i < limit && str[i + startIndex] == this.chars[i]; ++i) {
        }
        return i == this.chars.length ? this.chars.length : 0;
    }
}

