/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.mistletoe.core.helper;

public class ExceptionHelper {
    static String xLINE_SEPARATORX = "<br/>\r\n";
    static String LINE_SEPARATOR = "\r\n";
    public static final String CAUSED_BY = "Caused by: ";
    static final String TRACE_PREFIX = "&nbsp;&nbsp;";
    final Throwable throwable;
    int lines = 0;

    public ExceptionHelper(Throwable throwable) {
        this.throwable = throwable;
    }

    public int getLines() {
        return this.lines;
    }

    public String asString() {
        StringBuilder sbuf = new StringBuilder();
        Throwable t = this.throwable;
        Throwable parent = null;
        while (t != null) {
            this.innetRender(sbuf, parent, t);
            parent = t = t.getCause();
        }
        return sbuf.toString();
    }

    private void innetRender(StringBuilder sbuf, Throwable parent, Throwable t) {
        this.printFirstLine(sbuf, parent, t);
        int commonFrames = ExceptionHelper.findNumberOfCommonFrames(parent, t);
        StackTraceElement[] stepArray = t.getStackTrace();
        for (int i = 0; i < stepArray.length - commonFrames; ++i) {
            StackTraceElement step = stepArray[i];
            sbuf.append(TRACE_PREFIX);
            sbuf.append(ExceptionHelper.escapeTags(step.toString()));
            sbuf.append(LINE_SEPARATOR);
            ++this.lines;
        }
        if (commonFrames > 0) {
            sbuf.append(TRACE_PREFIX);
            sbuf.append("... " + commonFrames).append(" common frames omitted");
            sbuf.append(LINE_SEPARATOR);
            ++this.lines;
        }
    }

    private void printFirstLine(StringBuilder sb, Throwable parent, Throwable t) {
        int commonFrames = ExceptionHelper.findNumberOfCommonFrames(parent, t);
        if (commonFrames > 0) {
            sb.append(CAUSED_BY);
        }
        sb.append(t.getClass().getName()).append(": ").append(ExceptionHelper.escapeTags(t.getMessage()));
        sb.append(LINE_SEPARATOR);
        ++this.lines;
    }

    static int findNumberOfCommonFrames(Throwable parent, Throwable t) {
        StackTraceElement otherSte;
        StackTraceElement ste;
        if (parent == null) {
            return 0;
        }
        StackTraceElement[] parentSTEPArray = parent.getStackTrace();
        StackTraceElement[] steArray = t.getStackTrace();
        if (parentSTEPArray == null) {
            return 0;
        }
        int steIndex = steArray.length - 1;
        int count = 0;
        for (int parentIndex = parentSTEPArray.length - 1; steIndex >= 0 && parentIndex >= 0 && (ste = steArray[steIndex]).equals(otherSte = parentSTEPArray[parentIndex]); --steIndex, --parentIndex) {
            ++count;
        }
        return count;
    }

    private static String escapeTags(String input) {
        if (input == null || input.length() == 0 || input.indexOf("<") == -1 && input.indexOf(">") == -1) {
            return input;
        }
        StringBuffer buf = new StringBuffer(input);
        return ExceptionHelper.escapeTags(buf);
    }

    private static String escapeTags(StringBuffer buf) {
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (ch == '<') {
                buf.replace(i, i + 1, "&lt;");
                continue;
            }
            if (ch != '>') continue;
            buf.replace(i, i + 1, "&gt;");
        }
        return buf.toString();
    }
}

