/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.mistletoe.core;

import ch.qos.mistletoe.core.StopWatchRunListener;
import ch.qos.mistletoe.core.TestReport;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MistletoeCore {
    private final Class<?> targetClass;
    private final RunNotifier notifier = new RunNotifier();
    final StopWatchRunListener swRunListener = new StopWatchRunListener();
    Description description;
    Result result;

    public MistletoeCore(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public MistletoeCore(String targetClassStr) throws ClassNotFoundException {
        if (targetClassStr == null) {
            throw new NullPointerException("[targetClassStr] cannot be null");
        }
        this.targetClass = Class.forName(targetClassStr);
    }

    public Description getDescription() {
        return this.description;
    }

    public Result getResult() {
        return this.result;
    }

    public StopWatchRunListener getStopWatchRunListener() {
        return this.swRunListener;
    }

    public TestReport run() {
        Computer defaultComputer = new Computer();
        Request request = Request.classes((Computer)defaultComputer, (Class[])new Class[]{this.targetClass});
        Runner runner = request.getRunner();
        this.result = this.run(runner);
        this.description = runner.getDescription();
        TestReport testReport = new TestReport(this.description, this);
        return testReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result run(Runner runner) {
        Result result = new Result();
        RunListener listener = result.createListener();
        this.notifier.addFirstListener(listener);
        this.notifier.addListener((RunListener)this.swRunListener);
        try {
            this.notifier.fireTestRunStarted(runner.getDescription());
            runner.run(this.notifier);
            this.notifier.fireTestRunFinished(result);
        }
        finally {
            this.notifier.removeListener(listener);
        }
        return result;
    }

    public boolean hasAssociatedFailures(Description d) {
        List failureList = this.result.getFailures();
        for (Failure f : failureList) {
            if (f.getDescription().equals((Object)d)) {
                return true;
            }
            if (this.description.isTest()) {
                return false;
            }
            ArrayList descriptionList = d.getChildren();
            for (Description child : descriptionList) {
                if (!this.hasAssociatedFailures(child)) continue;
                return true;
            }
        }
        return false;
    }

    static void dumpDescription(StopWatchRunListener myListener, Description description) {
        if (description.isSuite()) {
            MistletoeCore.dumpSuite(myListener, description, "");
        } else {
            MistletoeCore.dumpTest(myListener, description, "");
        }
    }

    static void dumpTest(StopWatchRunListener myListener, Description description, String offset) {
        System.out.println(offset + "T -----");
        System.out.println(offset + "T display name=" + description.getDisplayName());
        System.out.println(offset + "T getClassName=" + description.getClassName());
        System.out.println(offset + "T getMethodName=" + description.getMethodName());
        System.out.println(offset + "T test count=" + description.testCount());
        System.out.println(offset + "T getAnnotations=" + description.getAnnotations());
        System.out.println(offset + "T runtime =" + myListener.getRunTime(description));
    }

    static void dumpSuite(StopWatchRunListener myListener, Description description, String offset) {
        System.out.println(offset + "display name=" + description.getDisplayName());
        System.out.println(offset + "getClassName=" + description.getClassName());
        System.out.println(offset + "test count=" + description.testCount());
        ArrayList children = description.getChildren();
        for (Description child : children) {
            if (child.isSuite()) {
                MistletoeCore.dumpSuite(myListener, child, offset + "  ");
                continue;
            }
            MistletoeCore.dumpTest(myListener, child, offset + "  ");
        }
    }

    static void dumpResult(Result result) {
        System.out.println("Failure count=" + result.getFailureCount());
        System.out.println("Run count=" + result.getRunCount());
        List failureList = result.getFailures();
        for (Failure f : failureList) {
            System.out.println("header=" + f.getTestHeader());
            System.out.println("msg=" + f.getMessage());
            System.out.println(f.getTrace());
        }
    }
}

