/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.mistletoe.core;

import ch.qos.mistletoe.core.MistletoeCore;
import ch.qos.mistletoe.core.StopWatchRunListener;
import ch.qos.mistletoe.sample.MyCollection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MistletoeCoreTest {
    @Test
    public void smoke() {
        MistletoeCore mCore = new MistletoeCore(MyCollection.class);
        mCore.run();
        Result result = mCore.getResult();
        Description description = mCore.getDescription();
        Assert.assertEquals((long)4L, (long)description.testCount());
        Assert.assertEquals((long)1L, (long)result.getFailureCount());
        System.out.println();
        System.out.println("=============== DUMP ============");
        System.out.println();
        MistletoeCore.dumpDescription((StopWatchRunListener)mCore.getStopWatchRunListener(), (Description)mCore.getDescription());
    }

    @Test
    public void hasAssociatedFailures() {
        MistletoeCore mCore = new MistletoeCore(MyCollection.class);
        mCore.run();
        Description description = mCore.getDescription();
        Assert.assertTrue((boolean)mCore.hasAssociatedFailures(description));
        HashMap<Description, Boolean> map = new HashMap<Description, Boolean>();
        this.doCheck(map, mCore, description);
        for (Description d : map.keySet()) {
            System.out.println(d + ", " + map.get(d));
        }
    }

    void doCheck(Map<Description, Boolean> map, MistletoeCore mCore, Description d) {
        boolean withFailures = mCore.hasAssociatedFailures(d);
        map.put(d, withFailures);
        for (Description c : d.getChildren()) {
            this.doCheck(map, mCore, c);
        }
    }
}

