/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.replay;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.SimpleConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.replay.Fruit;
import ch.qos.logback.core.joran.replay.FruitContext;
import ch.qos.logback.core.joran.replay.FruitFactory;
import ch.qos.logback.core.joran.replay.FruitFactoryAction;
import ch.qos.logback.core.joran.replay.FruitShell;
import ch.qos.logback.core.joran.replay.FruitShellAction;
import ch.qos.logback.core.joran.replay.WeightytFruit;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FruitConfigurationTest
extends TestCase {
    FruitContext fruitContext = new FruitContext();

    public FruitConfigurationTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public List<FruitShell> doFirstPart(String filename) throws Exception {
        try {
            HashMap<Pattern, Action> rulesMap = new HashMap<Pattern, Action>();
            rulesMap.put(new Pattern("group/fruitShell"), new FruitShellAction());
            rulesMap.put(new Pattern("group/fruitShell/fruit"), new FruitFactoryAction());
            rulesMap.put(new Pattern("group/fruitShell/fruit/*"), (Action)new NOPAction());
            SimpleConfigurator simpleConfigurator = new SimpleConfigurator(rulesMap);
            simpleConfigurator.setContext((Context)this.fruitContext);
            simpleConfigurator.doConfigure("src/test/input/joran/" + filename);
            return this.fruitContext.getFruitShellList();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }

    public void test1() throws Exception {
        List<FruitShell> fsList = this.doFirstPart("fruit1.xml");
        FruitConfigurationTest.assertNotNull(fsList);
        FruitConfigurationTest.assertEquals((int)1, (int)fsList.size());
        FruitShell fs0 = fsList.get(0);
        FruitConfigurationTest.assertNotNull((Object)((Object)fs0));
        FruitConfigurationTest.assertEquals((String)"fs0", (String)fs0.getName());
        Fruit fruit0 = fs0.fruitFactory.buildFruit();
        FruitConfigurationTest.assertTrue((boolean)(fruit0 instanceof Fruit));
        FruitConfigurationTest.assertEquals((String)"blue", (String)fruit0.getName());
    }

    public void test2() throws Exception {
        List<FruitShell> fsList = this.doFirstPart("fruit2.xml");
        FruitConfigurationTest.assertNotNull(fsList);
        FruitConfigurationTest.assertEquals((int)2, (int)fsList.size());
        FruitShell fs0 = fsList.get(0);
        FruitConfigurationTest.assertNotNull((Object)((Object)fs0));
        FruitConfigurationTest.assertEquals((String)"fs0", (String)fs0.getName());
        Fruit fruit0 = fs0.fruitFactory.buildFruit();
        FruitConfigurationTest.assertTrue((boolean)(fruit0 instanceof Fruit));
        FruitConfigurationTest.assertEquals((String)"blue", (String)fruit0.getName());
        FruitShell fs1 = fsList.get(1);
        FruitConfigurationTest.assertNotNull((Object)((Object)fs1));
        FruitConfigurationTest.assertEquals((String)"fs1", (String)fs1.getName());
        Fruit fruit1 = fs1.fruitFactory.buildFruit();
        FruitConfigurationTest.assertTrue((boolean)(fruit1 instanceof WeightytFruit));
        FruitConfigurationTest.assertEquals((String)"orange", (String)fruit1.getName());
        FruitConfigurationTest.assertEquals((Object)1.2, (Object)((WeightytFruit)fruit1).getWeight());
    }

    public void testWithSubst() throws Exception {
        List<FruitShell> fsList = this.doFirstPart("fruitWithSubst.xml");
        FruitConfigurationTest.assertNotNull(fsList);
        FruitConfigurationTest.assertEquals((int)1, (int)fsList.size());
        FruitShell fs0 = fsList.get(0);
        FruitConfigurationTest.assertNotNull((Object)((Object)fs0));
        FruitConfigurationTest.assertEquals((String)"fs0", (String)fs0.getName());
        int oldCount = FruitFactory.count;
        Fruit fruit0 = fs0.fruitFactory.buildFruit();
        FruitConfigurationTest.assertTrue((boolean)(fruit0 instanceof WeightytFruit));
        FruitConfigurationTest.assertEquals((String)("orange-" + oldCount), (String)fruit0.getName());
        FruitConfigurationTest.assertEquals((Object)1.2, (Object)((WeightytFruit)fruit0).getWeight());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(FruitConfigurationTest.class);
        return suite;
    }
}

