/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.Compare;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TimeBasedRollingTest
extends TestCase {
    static final String DATE_PATTERN = "yyyy-MM-dd_HH_mm_ss";
    EchoLayout<Object> layout = new EchoLayout();
    Context context = new ContextBase();

    public TimeBasedRollingTest(String name) {
        super(name);
    }

    public void setUp() {
        this.context.setName("test");
        File target = new File("src/test/output/test4.log");
        target.mkdirs();
        target.delete();
        target = new File("src/test/output/test5.log");
        target.mkdirs();
        target.delete();
        target = new File("src/test/output/test6.log");
        target.mkdirs();
        target.delete();
    }

    public void tearDown() {
    }

    public void test1() throws Exception {
        int i;
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        long currentTime = cal.getTimeInMillis();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context);
        rfa.setLayout(this.layout);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern("src/test/output/test1-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp.setParent((FileAppender)rfa);
        tbrp.setCurrentTime(currentTime);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[3];
        for (i = 0; i < 3; ++i) {
            filenames[i] = "src/test/output/test1-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        tbrp.setCurrentTime(TimeBasedRollingTest.addTime(currentTime, 1100L));
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            tbrp.setCurrentTime(TimeBasedRollingTest.addTime(tbrp.getCurrentTime(), 500L));
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test1." + i));
        }
    }

    public void test2() throws Exception {
        int i;
        int i2;
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        long currentTime = cal.getTimeInMillis();
        RollingFileAppender rfa1 = new RollingFileAppender();
        rfa1.setContext(this.context);
        rfa1.setLayout(this.layout);
        TimeBasedRollingPolicy tbrp1 = new TimeBasedRollingPolicy();
        tbrp1.setFileNamePattern("src/test/output/test2-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp1.setContext(this.context);
        tbrp1.setParent((FileAppender)rfa1);
        tbrp1.setCurrentTime(currentTime);
        tbrp1.start();
        rfa1.setRollingPolicy((RollingPolicy)tbrp1);
        rfa1.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[3];
        for (i2 = 0; i2 < 3; ++i2) {
            filenames[i2] = "src/test/output/test2-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        tbrp1.setCurrentTime(TimeBasedRollingTest.addTime(currentTime, 1100L));
        for (i2 = 0; i2 <= 2; ++i2) {
            rfa1.doAppend((Object)("Hello---" + i2));
            tbrp1.setCurrentTime(TimeBasedRollingTest.addTime(tbrp1.getCurrentTime(), 500L));
        }
        rfa1.stop();
        RollingFileAppender rfa2 = new RollingFileAppender();
        rfa2.setContext(this.context);
        rfa2.setLayout(this.layout);
        TimeBasedRollingPolicy tbrp2 = new TimeBasedRollingPolicy();
        tbrp2.setContext(this.context);
        tbrp2.setFileNamePattern("src/test/output/test2-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp2.setParent((FileAppender)rfa2);
        tbrp2.setCurrentTime(tbrp1.getCurrentTime());
        tbrp2.start();
        rfa2.setRollingPolicy((RollingPolicy)tbrp2);
        rfa2.start();
        for (i = 0; i <= 2; ++i) {
            rfa2.doAppend((Object)("Hello---" + i));
            tbrp2.setCurrentTime(TimeBasedRollingTest.addTime(tbrp2.getCurrentTime(), 100L));
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test2." + i));
        }
    }

    public void test3() throws Exception {
        int i;
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        long currentTime = cal.getTimeInMillis();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context);
        rfa.setLayout(this.layout);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern("src/test/output/test3-%d{yyyy-MM-dd_HH_mm_ss}.gz");
        tbrp.setParent((FileAppender)rfa);
        tbrp.setCurrentTime(currentTime);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[4];
        for (i = 0; i < 2; ++i) {
            filenames[i] = "src/test/output/test3-" + sdf.format(cal.getTime()) + ".gz";
            cal.add(13, 1);
        }
        filenames[3] = "src/test/output/test3-" + sdf.format(cal.getTime());
        tbrp.setCurrentTime(TimeBasedRollingTest.addTime(currentTime, 1100L));
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            tbrp.setCurrentTime(TimeBasedRollingTest.addTime(tbrp.getCurrentTime(), 500L));
        }
        for (i = 0; i < 2; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.gzCompare(filenames[i], "src/test/witness/rolling/tbr-test3." + i + ".gz"));
        }
        TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[3], "src/test/witness/rolling/tbr-test3.2"));
    }

    public void test4() throws Exception {
        int i;
        int i2;
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        long currentTime = cal.getTimeInMillis();
        RollingFileAppender rfa1 = new RollingFileAppender();
        rfa1.setContext(this.context);
        rfa1.setLayout(this.layout);
        rfa1.setFile("src/test/output/test4.log");
        TimeBasedRollingPolicy tbrp1 = new TimeBasedRollingPolicy();
        tbrp1.setContext(this.context);
        tbrp1.setFileNamePattern("src/test/output/test4-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp1.setParent((FileAppender)rfa1);
        tbrp1.setCurrentTime(currentTime);
        tbrp1.start();
        rfa1.setRollingPolicy((RollingPolicy)tbrp1);
        rfa1.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[3];
        for (i2 = 0; i2 < 2; ++i2) {
            filenames[i2] = "src/test/output/test4-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        filenames[2] = "src/test/output/test4.log";
        tbrp1.setCurrentTime(TimeBasedRollingTest.addTime(currentTime, 1100L));
        for (i2 = 0; i2 <= 2; ++i2) {
            rfa1.doAppend((Object)("Hello---" + i2));
            tbrp1.setCurrentTime(TimeBasedRollingTest.addTime(tbrp1.getCurrentTime(), 500L));
        }
        rfa1.stop();
        RollingFileAppender rfa2 = new RollingFileAppender();
        rfa2.setContext(this.context);
        rfa2.setLayout(this.layout);
        rfa2.setFile("src/test/output/test4.log");
        TimeBasedRollingPolicy tbrp2 = new TimeBasedRollingPolicy();
        tbrp2.setContext(this.context);
        tbrp2.setFileNamePattern("src/test/output/test4-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp2.setParent((FileAppender)rfa2);
        tbrp2.setCurrentTime(tbrp1.getCurrentTime());
        tbrp2.start();
        rfa2.setRollingPolicy((RollingPolicy)tbrp2);
        rfa2.start();
        for (i = 0; i <= 2; ++i) {
            rfa2.doAppend((Object)("Hello---" + i));
            tbrp2.setCurrentTime(TimeBasedRollingTest.addTime(tbrp2.getCurrentTime(), 100L));
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test4." + i));
        }
    }

    public void test5() throws Exception {
        int i;
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        long currentTime = cal.getTimeInMillis();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context);
        rfa.setLayout(this.layout);
        rfa.setFile("src/test/output/test5.log");
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern("src/test/output/test5-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp.setParent((FileAppender)rfa);
        tbrp.setCurrentTime(currentTime);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[4];
        for (i = 0; i < 2; ++i) {
            filenames[i] = "src/test/output/test5-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        filenames[2] = "src/test/output/test5.log";
        tbrp.setCurrentTime(TimeBasedRollingTest.addTime(currentTime, 1100L));
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            tbrp.setCurrentTime(TimeBasedRollingTest.addTime(tbrp.getCurrentTime(), 500L));
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test5." + i));
        }
    }

    public void test6() throws Exception {
        int i;
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        long currentTime = cal.getTimeInMillis();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context);
        rfa.setLayout(this.layout);
        rfa.setFile("src/test/output/test6.log");
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern("src/test/output/test6-%d{yyyy-MM-dd_HH_mm_ss}.gz");
        tbrp.setParent((FileAppender)rfa);
        tbrp.setCurrentTime(currentTime);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[4];
        for (i = 0; i < 2; ++i) {
            filenames[i] = "src/test/output/test6-" + sdf.format(cal.getTime()) + ".gz";
            cal.add(13, 1);
        }
        filenames[2] = "src/test/output/test6.log";
        tbrp.setCurrentTime(TimeBasedRollingTest.addTime(currentTime, 1100L));
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            tbrp.setCurrentTime(TimeBasedRollingTest.addTime(tbrp.getCurrentTime(), 500L));
        }
        for (i = 0; i < 2; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.gzCompare(filenames[i], "src/test/witness/rolling/tbr-test6." + i + ".gz"));
        }
        TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[2], "src/test/witness/rolling/tbr-test6.2"));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TimeBasedRollingTest.class);
        return suite;
    }

    static long addTime(long currentTime, long timeToWait) {
        return currentTime + timeToWait;
    }
}

