/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.Compare;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedRollingTest {
    static final String DATE_PATTERN = "yyyy-MM-dd_HH_mm_ss";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
    EchoLayout<Object> layout = new EchoLayout();
    Context context = new ContextBase();
    RollingFileAppender<Object> rfa1 = new RollingFileAppender();
    TimeBasedRollingPolicy tbrp1 = new TimeBasedRollingPolicy();
    RollingFileAppender<Object> rfa2 = new RollingFileAppender();
    TimeBasedRollingPolicy tbrp2 = new TimeBasedRollingPolicy();
    Calendar cal = Calendar.getInstance();
    long currentTime;
    long nextRolloverThreshold;
    List<String> expectedFilenameList = new ArrayList<String>();

    @Before
    public void setUp() {
        this.context.setName("test");
        this.cal.set(14, 333);
        this.currentTime = this.cal.getTimeInMillis();
        this.recomputeRolloverThreshold(this.currentTime);
        System.out.println("at setUp() currentTime=" + this.sdf.format(new java.sql.Date(this.currentTime)));
        this.deleteStaleLogFile("test4.log");
        this.deleteStaleLogFile("test4B.log");
        this.deleteStaleLogFile("test5.log");
        this.deleteStaleLogFile("test6.log");
    }

    void deleteStaleLogFile(String filename) {
        File target = new File("target/test-output/" + filename);
        target.mkdirs();
        target.delete();
    }

    @After
    public void tearDown() {
    }

    void initRFA(RollingFileAppender<Object> rfa, String filename) {
        rfa.setContext(this.context);
        rfa.setLayout(this.layout);
        if (filename != null) {
            rfa.setFile(filename);
        }
    }

    void initTRBP(RollingFileAppender<Object> rfa, TimeBasedRollingPolicy tbrp, String filenamePattern, long givenTime, long lastCheck) {
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern(filenamePattern);
        tbrp.setParent(rfa);
        tbrp.setCurrentTime(givenTime);
        if (lastCheck != 0L) {
            tbrp.setLastCheck((Date)new java.sql.Date(lastCheck));
        }
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        tbrp.start();
        rfa.start();
    }

    @Test
    public void noCompression_FileBlank_NoRestart_1() throws Exception {
        int i;
        String testId = "test1";
        this.initRFA(this.rfa1, null);
        this.initTRBP(this.rfa1, this.tbrp1, "target/test-output/" + testId + "-%d{" + DATE_PATTERN + "}", this.currentTime, 0L);
        this.addExpectedFileName_ByDate(testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.setCurrentTime(this.currentTime);
        for (i = 0; i < 3; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.setCurrentTime(this.currentTime);
        }
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-" + testId + "." + i++));
        }
    }

    @Test
    public void noCompression_FileBlank_StopRestart_2() throws Exception {
        int i;
        String testId = "test2";
        this.initRFA(this.rfa1, null);
        this.initTRBP(this.rfa1, this.tbrp1, "target/test-output/" + testId + "-%d{" + DATE_PATTERN + "}", this.currentTime, 0L);
        this.addExpectedFileName_ByDate(testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.setCurrentTime(this.currentTime);
        for (i = 0; i <= 2; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.setCurrentTime(this.currentTime);
        }
        this.rfa1.stop();
        this.initRFA(this.rfa2, null);
        this.initTRBP(this.rfa2, this.tbrp2, "target/test-output/" + testId + "-%d{" + DATE_PATTERN + "}", this.tbrp1.getCurrentTime(), 0L);
        for (i = 0; i <= 2; ++i) {
            this.addExpectedFileNamedIfItsTime_ByDate(testId, false);
            this.rfa2.doAppend((Object)("World---" + i));
            this.incCurrentTime(100L);
            this.tbrp2.setCurrentTime(this.currentTime);
        }
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-" + testId + "." + i++));
        }
    }

    @Test
    public void withCompression_FileBlank_NoRestart_3() throws Exception {
        int i;
        String testId = "test3";
        this.initRFA(this.rfa1, null);
        this.initTRBP(this.rfa1, this.tbrp1, "target/test-output/" + testId + "-%d{" + DATE_PATTERN + "}.gz", this.currentTime, 0L);
        this.addExpectedFileName_ByDate(testId, this.getDateOfCurrentPeriodsStart(), true);
        this.incCurrentTime(1100L);
        this.tbrp1.setCurrentTime(this.currentTime);
        for (i = 0; i < 3; ++i) {
            this.addExpectedFileNamedIfItsTime_ByDate(testId, i != 2);
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.incCurrentTime(500L);
            this.tbrp1.setCurrentTime(this.currentTime);
        }
        this.tbrp1.future.get(2000L, TimeUnit.MILLISECONDS);
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-" + testId + "." + i + this.addGZIfNotLast(i)));
            ++i;
        }
    }

    @Test
    public void noCompression_FileSet_StopRestart_4() throws Exception {
        int i;
        String testId = "test4";
        this.initRFA(this.rfa1, this.testId2FileName(testId));
        this.initTRBP(this.rfa1, this.tbrp1, "target/test-output/" + testId + "-%d{" + DATE_PATTERN + "}", this.currentTime, 0L);
        this.addExpectedFileName_ByDate(testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.setCurrentTime(this.currentTime);
        for (i = 0; i <= 2; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.setCurrentTime(this.currentTime);
        }
        this.rfa1.stop();
        this.initRFA(this.rfa2, this.testId2FileName(testId));
        this.initTRBP(this.rfa2, this.tbrp2, "target/test-output/" + testId + "-%d{" + DATE_PATTERN + "}", this.currentTime, this.currentTime);
        for (i = 0; i <= 2; ++i) {
            this.rfa2.doAppend((Object)("World---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(testId, false);
            this.incCurrentTime(100L);
            this.tbrp2.setCurrentTime(this.currentTime);
        }
        this.massageExpectedFilesToCorresponToCurrentTarget("test4.log");
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-" + testId + "." + i++));
        }
    }

    @Test
    public void noCompression_FileSet_StopRestart_WithLongWait_4B() throws Exception {
        int i;
        String testId = "test4B";
        this.initRFA(this.rfa1, this.testId2FileName(testId));
        this.initTRBP(this.rfa1, this.tbrp1, "target/test-output/" + testId + "-%d{" + DATE_PATTERN + "}", this.currentTime, 0L);
        this.addExpectedFileName_ByDate(testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.setCurrentTime(this.currentTime);
        for (int i2 = 0; i2 <= 2; ++i2) {
            this.rfa1.doAppend((Object)("Hello---" + i2));
            this.addExpectedFileNamedIfItsTime_ByDate(testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.setCurrentTime(this.currentTime);
        }
        this.rfa1.stop();
        long fileTimestamp = this.currentTime;
        this.incCurrentTime(2000L);
        this.initRFA(this.rfa2, "target/test-output/test4B.log");
        this.initTRBP(this.rfa2, this.tbrp2, "target/test-output/" + testId + "-%d{" + DATE_PATTERN + "}", this.currentTime, fileTimestamp);
        for (i = 0; i <= 2; ++i) {
            this.rfa2.doAppend((Object)("World---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(testId, false);
            this.incCurrentTime(100L);
            this.tbrp2.setCurrentTime(this.currentTime);
        }
        this.massageExpectedFilesToCorresponToCurrentTarget("test4B.log");
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-test4B." + i++));
        }
    }

    @Test
    public void noCompression_FileSet_NoRestart_5() throws Exception {
        int i;
        String testId = "test5";
        this.initRFA(this.rfa1, this.testId2FileName(testId));
        this.initTRBP(this.rfa1, this.tbrp1, "target/test-output/" + testId + "-%d{" + DATE_PATTERN + "}", this.currentTime, 0L);
        this.addExpectedFileName_ByDate(testId, this.getDateOfCurrentPeriodsStart(), false);
        this.incCurrentTime(1100L);
        this.tbrp1.setCurrentTime(this.currentTime);
        for (i = 0; i < 3; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(testId, false);
            this.incCurrentTime(500L);
            this.tbrp1.setCurrentTime(this.currentTime);
        }
        this.massageExpectedFilesToCorresponToCurrentTarget("test5.log");
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-test5." + i++));
        }
    }

    @Test
    public void withCompression_FileSet_NoRestart_6() throws Exception {
        int i;
        String testId = "test6";
        this.initRFA(this.rfa1, this.testId2FileName(testId));
        this.initTRBP(this.rfa1, this.tbrp1, "target/test-output/" + testId + "-%d{" + DATE_PATTERN + "}.gz", this.currentTime, 0L);
        this.addExpectedFileName_ByDate(testId, this.getDateOfCurrentPeriodsStart(), true);
        this.incCurrentTime(1100L);
        this.tbrp1.setCurrentTime(this.currentTime);
        for (i = 0; i < 3; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(testId, true);
            this.incCurrentTime(500L);
            this.tbrp1.setCurrentTime(this.currentTime);
        }
        this.tbrp1.future.get(1000L, TimeUnit.MILLISECONDS);
        this.massageExpectedFilesToCorresponToCurrentTarget("test6.log");
        i = 0;
        for (String fn : this.expectedFilenameList) {
            Assert.assertTrue((boolean)Compare.compare(fn, "src/test/witness/rolling/tbr-" + testId + "." + i + this.addGZIfNotLast(i)));
            ++i;
        }
    }

    String testId2FileName(String testId) {
        return "target/test-output/" + testId + ".log";
    }

    void massageExpectedFilesToCorresponToCurrentTarget(String file) {
        this.expectedFilenameList.remove(this.expectedFilenameList.size() - 1);
        this.addExpectedFileName_ByFile(file);
    }

    String addGZIfNotLast(int i) {
        int lastIndex = this.expectedFilenameList.size() - 1;
        if (i != lastIndex) {
            return ".gz";
        }
        return "";
    }

    void addExpectedFileName_ByDate(String testId, java.sql.Date date, boolean gzExtension) {
        String fn = "target/test-output/" + testId + "-" + this.sdf.format(date);
        if (gzExtension) {
            fn = fn + ".gz";
        }
        this.expectedFilenameList.add(fn);
    }

    void addExpectedFileNamedIfItsTime_ByDate(String testId, boolean gzExtension) {
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.addExpectedFileName_ByDate(testId, this.getDateOfCurrentPeriodsStart(), gzExtension);
            this.recomputeRolloverThreshold(this.currentTime);
        }
    }

    void addExpectedFileName_ByFile(String filenameSuffix) {
        String fn = "target/test-output/" + filenameSuffix;
        this.expectedFilenameList.add(fn);
    }

    java.sql.Date getDateOfCurrentPeriodsStart() {
        long delta = this.currentTime % 1000L;
        return new java.sql.Date(this.currentTime - delta);
    }

    java.sql.Date getDateOfPastPeriodsStart() {
        long delta = this.currentTime % 1000L;
        return new java.sql.Date(this.currentTime - delta - 1000L);
    }

    static long addTime(long currentTime, long timeToWait) {
        return currentTime + timeToWait;
    }

    boolean passThresholdTime(long nextRolloverThreshold) {
        return this.currentTime >= nextRolloverThreshold;
    }

    void recomputeRolloverThreshold(long ct) {
        long delta = ct % 1000L;
        this.nextRolloverThreshold = ct - delta + 1000L;
    }

    void incCurrentTime(long increment) {
        this.currentTime += increment;
    }

    void printLongAsDate(String msg, long time) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        System.out.println(msg + sdf.format(new java.sql.Date(time)));
    }
}

