/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import java.io.File;
import java.io.FilenameFilter;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeBasedRollingWithCleanTest {
    Context context = new ContextBase();
    EchoLayout<Object> layout = new EchoLayout();
    static final String MONTHLY_DATE_PATTERN = "yyyy-MM";
    static final String DAILY_DATE_PATTERN = "yyyy-MM-dd";
    static final long MILLIS_IN_MINUTE = 60000L;
    static final long MILLIS_IN_HOUR = 3600000L;
    static final long MILLIS_IN_DAY = 86400000L;
    static final long MILLIS_IN_MONTH = 2592000000L;

    @Before
    public void setUp() throws Exception {
        this.context.setName("test");
        File dir = new File("target/test-output/");
        if (dir.isDirectory()) {
            File[] toDelete;
            for (File f : toDelete = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.contains("clean");
                }
            })) {
                System.out.println(f);
                f.delete();
            }
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void montlyRollover() throws Exception {
        this.doRollover("target/test-output/clean-%d{yyyy-MM}.txt", 2592000000L, 20);
    }

    @Test
    public void dailyRollover() throws Exception {
        this.doRollover("target/test-output/clean-%d{yyyy-MM-dd}.txt.zip", 86400000L, 5);
    }

    void doRollover(String fileNamePattern, long delay, int maxHistory) throws Exception {
        long currentTime = System.currentTimeMillis();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext(this.context);
        rfa.setLayout(this.layout);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext(this.context);
        tbrp.setFileNamePattern(fileNamePattern);
        tbrp.setMaxHistory(maxHistory);
        tbrp.setParent((FileAppender)rfa);
        tbrp.setCurrentTime(currentTime);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        for (int i = 0; i < maxHistory * 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            tbrp.setCurrentTime(TimeBasedRollingWithCleanTest.addTime(tbrp.getCurrentTime(), delay / 2L));
            if (tbrp.future == null) continue;
            tbrp.future.get(200L, TimeUnit.MILLISECONDS);
        }
        rfa.stop();
        this.check(maxHistory + 1);
    }

    void check(int expectedCount) {
        File dir = new File("target/test-output/");
        if (dir.isDirectory()) {
            File[] match = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.contains("clean");
                }
            });
            Assert.assertEquals((long)expectedCount, (long)match.length);
        }
    }

    static long addTime(long currentTime, long timeToWait) {
        return currentTime + timeToWait;
    }
}

