/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import ch.qos.logback.core.Layout;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThrowableToStringArrayTest {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(this.sw);

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public void verify(Throwable t) {
        t.printStackTrace(this.pw);
        String[] sa = ThrowableToStringArray.convert((Throwable)t);
        StringBuilder sb = new StringBuilder();
        for (String tdp : sa) {
            sb.append(tdp.toString());
            sb.append(Layout.LINE_SEP);
        }
        String expected = this.sw.toString();
        String result = sb.toString().replace("common frames omitted", "more");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void smoke() {
        Exception e = new Exception("smoke");
        this.verify(e);
    }

    @Test
    public void nested() {
        Exception w = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            w = new Exception("wrapping", e);
        }
        this.verify(w);
    }

    @Test
    public void multiNested() {
        Exception w = null;
        try {
            this.someOtherMethod();
        }
        catch (Exception e) {
            w = new Exception("wrapping", e);
        }
        this.verify(w);
    }

    void someMethod() throws Exception {
        throw new Exception("someMethod");
    }

    void someOtherMethod() throws Exception {
        try {
            this.someMethod();
        }
        catch (Exception e) {
            throw new Exception("someOtherMethod", e);
        }
    }
}

