/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.ContainmentType;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.PropertySetterException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class PropertySetter
extends ContextAwareBase {
    private static final int X_NOT_FOUND = 0;
    private static final int X_AS_COMPONENT = 1;
    private static final int X_AS_PROPERTY = 2;
    protected Object obj;
    protected Class objClass;
    protected PropertyDescriptor[] propertyDescriptors;
    protected MethodDescriptor[] methodDescriptors;

    public PropertySetter(Object obj) {
        this.obj = obj;
        this.objClass = obj.getClass();
    }

    protected void introspect() {
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.obj.getClass());
            this.propertyDescriptors = bi.getPropertyDescriptors();
            this.methodDescriptors = bi.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            this.addError("Failed to introspect " + this.obj + ": " + ex.getMessage());
            this.propertyDescriptors = new PropertyDescriptor[0];
            this.methodDescriptors = new MethodDescriptor[0];
        }
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            return;
        }
        PropertyDescriptor prop = this.getPropertyDescriptor(name = Introspector.decapitalize(name));
        if (prop == null) {
            this.addWarn("No such property [" + name + "] in " + this.objClass.getName() + ".");
        } else {
            try {
                this.setProperty(prop, name, value);
            }
            catch (PropertySetterException ex) {
                this.addWarn("Failed to set property [" + name + "] to value \"" + value + "\". ", ex);
            }
        }
    }

    public void setProperty(PropertyDescriptor prop, String name, String value) throws PropertySetterException {
        Object arg;
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            throw new PropertySetterException("No setter for property [" + name + "].");
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        if (paramTypes.length != 1) {
            throw new PropertySetterException("#params for setter != 1");
        }
        try {
            arg = this.convertArg(value, paramTypes[0]);
        }
        catch (Throwable t) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed. ", t);
        }
        if (arg == null) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed.");
        }
        try {
            setter.invoke(this.obj, arg);
        }
        catch (Exception ex) {
            throw new PropertySetterException(ex);
        }
    }

    public ContainmentType canContainComponent(String name) {
        Method setterMethod;
        String dName;
        PropertyDescriptor propertyDescriptor;
        String cName = this.capitalizeFirstLetter(name);
        Method addMethod = this.getMethod("add" + cName);
        if (addMethod != null) {
            int type = this.computeContainmentTpye(addMethod);
            switch (type) {
                case 0: {
                    return ContainmentType.NOT_FOUND;
                }
                case 2: {
                    return ContainmentType.AS_PROPERTY_COLLECTION;
                }
                case 1: {
                    return ContainmentType.AS_COMPONENT_COLLECTION;
                }
            }
        }
        if ((propertyDescriptor = this.getPropertyDescriptor(dName = Introspector.decapitalize(name))) != null && (setterMethod = propertyDescriptor.getWriteMethod()) != null) {
            int type = this.computeContainmentTpye(setterMethod);
            switch (type) {
                case 0: {
                    return ContainmentType.NOT_FOUND;
                }
                case 2: {
                    return ContainmentType.AS_SINGLE_PROPERTY;
                }
                case 1: {
                    return ContainmentType.AS_SINGLE_COMPONENT;
                }
            }
        }
        return ContainmentType.NOT_FOUND;
    }

    int computeContainmentTpye(Method setterMethod) {
        Class<?>[] classArray = setterMethod.getParameterTypes();
        if (classArray.length != 1) {
            return 0;
        }
        Class<?> clazz = classArray[0];
        Package p = clazz.getPackage();
        if (clazz.isPrimitive()) {
            return 2;
        }
        if ("java.lang".equals(p.getName())) {
            return 2;
        }
        if (Duration.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (FileSize.class.isAssignableFrom(clazz)) {
            return 2;
        }
        return 1;
    }

    public Class getObjClass() {
        return this.objClass;
    }

    public void addComponent(String name, Object childComponent) {
        Class<?> ccc = childComponent.getClass();
        name = this.capitalizeFirstLetter(name);
        Method method = this.getMethod("add" + name);
        if (method != null) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length == 1) {
                if (params[0].isAssignableFrom(childComponent.getClass())) {
                    try {
                        method.invoke(this.obj, childComponent);
                    }
                    catch (Exception e) {
                        this.addError("Could not invoke method " + method.getName() + " in class " + this.obj.getClass().getName() + " with parameter of type " + ccc.getName(), e);
                    }
                } else {
                    this.addError("A \"" + ccc.getName() + "\" object is not assignable to a \"" + params[0].getName() + "\" variable.");
                    this.addError("The class \"" + params[0].getName() + "\" was loaded by ");
                    this.addError("[" + params[0].getClassLoader() + "] whereas object of type ");
                    this.addError("\"" + ccc.getName() + "\" was loaded by [" + ccc.getClassLoader() + "].");
                }
            }
        } else {
            this.addError("Could not find method [add" + name + "] in class [" + this.objClass.getName() + "].");
        }
    }

    public void addProperty(String name, String strValue) {
        Object arg;
        if (strValue == null) {
            return;
        }
        name = this.capitalizeFirstLetter(name);
        Method adderMethod = this.getMethod("add" + name);
        if (adderMethod == null) {
            this.addError("No adder for property [" + name + "].");
            return;
        }
        Class<?>[] paramTypes = adderMethod.getParameterTypes();
        if (paramTypes.length != 1) {
            this.addError("#params for setter != 1");
            return;
        }
        try {
            arg = this.convertArg(strValue, paramTypes[0]);
        }
        catch (Throwable t) {
            this.addError("Conversion to type [" + paramTypes[0] + "] failed. ", t);
            return;
        }
        if (arg == null) {
            this.addError("Conversion to type [" + paramTypes[0] + "] failed.");
        } else {
            try {
                adderMethod.invoke(this.obj, arg);
            }
            catch (Exception ex) {
                this.addError("Failed to invoke adder for " + name, ex);
            }
        }
    }

    public void setComponent(String name, Object childComponent) {
        String dName = Introspector.decapitalize(name);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(dName);
        if (propertyDescriptor == null) {
            this.addWarn("Could not find PropertyDescriptor for [" + name + "] in " + this.objClass.getName());
            return;
        }
        Method setter = propertyDescriptor.getWriteMethod();
        if (setter == null) {
            this.addWarn("Not setter method for property [" + name + "] in " + this.obj.getClass().getName());
            return;
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        if (paramTypes.length != 1) {
            this.addError("Wrong number of parameters in setter method for property [" + name + "] in " + this.obj.getClass().getName());
            return;
        }
        try {
            setter.invoke(this.obj, childComponent);
        }
        catch (Exception e) {
            this.addError("Could not set component " + this.obj + " for parent component " + this.obj, e);
        }
    }

    String capitalizeFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected Object convertArg(String val, Class type) {
        if (val == null) {
            return null;
        }
        String v = val.trim();
        if (String.class.isAssignableFrom(type)) {
            return val;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return new Integer(v);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return new Long(v);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return new Float(v);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return new Double(v);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            if ("true".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
        } else {
            if (Duration.class.isAssignableFrom(type)) {
                return Duration.valueOf(val);
            }
            if (FileSize.class.isAssignableFrom(type)) {
                return FileSize.valueOf(val);
            }
        }
        return null;
    }

    protected Method getMethod(String methodName) {
        if (this.methodDescriptors == null) {
            this.introspect();
        }
        for (int i = 0; i < this.methodDescriptors.length; ++i) {
            if (!methodName.equals(this.methodDescriptors[i].getName())) continue;
            return this.methodDescriptors[i].getMethod();
        }
        return null;
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        if (this.propertyDescriptors == null) {
            this.introspect();
        }
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            if (!name.equals(this.propertyDescriptors[i].getName())) continue;
            return this.propertyDescriptors[i];
        }
        return null;
    }

    public Object getObj() {
        return this.obj;
    }
}

