/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.TimeUtil;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;

public class TimeUtilTest
extends TestCase {
    public TimeUtilTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSecond() {
        long now = 1164042317522L;
        long expected = 1164042318000L;
        long computed = TimeUtil.computeStartOfNextSecond((long)now);
        TimeUtilTest.assertEquals((long)(expected - now), (long)478L);
        TimeUtilTest.assertEquals((long)expected, (long)computed);
    }

    public void testMinute() {
        long now = 1164042317522L;
        long expected = 1164042360000L;
        long computed = TimeUtil.computeStartOfNextMinute((long)now);
        TimeUtilTest.assertEquals((long)(expected - now), (long)42478L);
        TimeUtilTest.assertEquals((long)expected, (long)computed);
    }

    public void testHour() {
        long now = 1164042317522L;
        long expected = 1164045600000L;
        long computed = TimeUtil.computeStartOfNextHour((long)now);
        TimeUtilTest.assertEquals((long)(expected - now), (long)3282478L);
        TimeUtilTest.assertEquals((long)expected, (long)computed);
    }

    public void testDay() {
        long now = 1164042317522L;
        long expected = 1164063600000L;
        long computed = TimeUtil.computeStartOfNextDay((long)now);
        TimeUtilTest.assertEquals((long)(expected - now), (long)21282478L);
        TimeUtilTest.assertEquals((long)expected, (long)computed);
    }

    public void testWeek() {
        long now = 1164042317522L;
        long expected = 1164495600000L;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(now));
        int dayOffset = cal.getFirstDayOfWeek() - 1;
        if (dayOffset != 0) {
            expected += 86400000L * (long)(cal.getFirstDayOfWeek() - 1);
        }
        long computed = TimeUtil.computeStartOfNextWeek((long)now);
        TimeUtilTest.assertEquals((long)(expected - now), (long)(1000 * (3600 * (5 + 24 * (5 + dayOffset)) + 3240 + 42) + 478));
        TimeUtilTest.assertEquals((long)expected, (long)computed);
    }

    public void testMonth() {
        long now = 1164042317522L;
        long expected = 1164927600000L;
        long computed = TimeUtil.computeStartOfNextMonth((long)now);
        TimeUtilTest.assertEquals((long)(expected - now), (long)885282478L);
        TimeUtilTest.assertEquals((long)expected, (long)computed);
    }
}

