/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.ContainmentType;
import ch.qos.logback.core.util.Door;
import ch.qos.logback.core.util.House;
import ch.qos.logback.core.util.PropertySetter;
import ch.qos.logback.core.util.SwimmingPool;
import ch.qos.logback.core.util.Window;
import junit.framework.TestCase;

public class PropertySetterTest
extends TestCase {
    public void testCanContainComponent() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_SINGLE_COMPONENT, (Object)setter.canContainComponent("door"));
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_SINGLE_PROPERTY, (Object)setter.canContainComponent("count"));
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_SINGLE_PROPERTY, (Object)setter.canContainComponent("Count"));
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_SINGLE_PROPERTY, (Object)setter.canContainComponent("name"));
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_SINGLE_PROPERTY, (Object)setter.canContainComponent("Name"));
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_SINGLE_PROPERTY, (Object)setter.canContainComponent("Duration"));
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_SINGLE_PROPERTY, (Object)setter.canContainComponent("fs"));
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_SINGLE_PROPERTY, (Object)setter.canContainComponent("open"));
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_SINGLE_PROPERTY, (Object)setter.canContainComponent("Open"));
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_COMPONENT_COLLECTION, (Object)setter.canContainComponent("Window"));
        PropertySetterTest.assertEquals((Object)ContainmentType.AS_PROPERTY_COLLECTION, (Object)setter.canContainComponent("adjective"));
    }

    public void testSetProperty() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("count", "10");
        setter.setProperty("name", "jack");
        setter.setProperty("open", "true");
        PropertySetterTest.assertEquals((int)10, (int)house.getCount());
        PropertySetterTest.assertEquals((String)"jack", (String)house.getName());
        PropertySetterTest.assertTrue((boolean)house.isOpen());
        house = new House();
        setter = new PropertySetter((Object)house);
        setter.setProperty("Count", "10");
        setter.setProperty("Name", "jack");
        setter.setProperty("Open", "true");
        PropertySetterTest.assertEquals((int)10, (int)house.getCount());
        PropertySetterTest.assertEquals((String)"jack", (String)house.getName());
        PropertySetterTest.assertTrue((boolean)house.isOpen());
    }

    public void testSetCamelProperty() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("camelCase", "trot");
        PropertySetterTest.assertEquals((String)"trot", (String)house.getCamelCase());
        setter.setProperty("camelCase", "gh");
        PropertySetterTest.assertEquals((String)"gh", (String)house.getCamelCase());
    }

    public void testSetComponent() {
        House house = new House();
        Door door = new Door();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setComponent("door", (Object)door);
        PropertySetterTest.assertEquals((Object)door, (Object)house.getDoor());
    }

    public void testPropertyCollection() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.addProperty("adjective", "nice");
        setter.addProperty("adjective", "big");
        PropertySetterTest.assertEquals((int)2, (int)house.adjectiveList.size());
        PropertySetterTest.assertEquals((String)"nice", (String)house.adjectiveList.get(0));
        PropertySetterTest.assertEquals((String)"big", (String)house.adjectiveList.get(1));
    }

    public void testComponentCollection() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        Window w1 = new Window();
        w1.handle = 10;
        Window w2 = new Window();
        w2.handle = 20;
        setter.addComponent("window", (Object)w1);
        setter.addComponent("window", (Object)w2);
        PropertySetterTest.assertEquals((int)2, (int)house.windowList.size());
        PropertySetterTest.assertEquals((int)10, (int)house.windowList.get((int)0).handle);
        PropertySetterTest.assertEquals((int)20, (int)house.windowList.get((int)1).handle);
    }

    public void testSetComponentWithCamelCaseName() {
        House house = new House();
        SwimmingPool pool = new SwimmingPool();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setComponent("swimmingPool", (Object)pool);
        PropertySetterTest.assertEquals((Object)pool, (Object)house.getSwimmingPool());
    }

    public void testDuration() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("duration", "1.4 seconds");
        PropertySetterTest.assertEquals((long)1400L, (long)house.getDuration().getMilliseconds());
    }

    public void testFileSize() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("fs", "2 kb");
        PropertySetterTest.assertEquals((long)2048L, (long)house.getFs().getSize());
    }
}

