/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.OptionHelper;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class OptionHelperTest
extends TestCase {
    String text = "Testing ${v1} variable substitution ${v2}";
    String expected = "Testing if variable substitution works";
    Map<String, String> primaryMap;
    Map<String, String> secondaryMap;

    protected void setUp() throws Exception {
        this.primaryMap = new HashMap<String, String>();
        this.secondaryMap = new HashMap<String, String>();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.primaryMap = null;
        this.primaryMap = null;
        super.tearDown();
    }

    public void testSubstVarsNoSubstitution() {
        String noSubst = "testing if it works";
        String result = OptionHelper.substVars((String)noSubst, null, null);
        OptionHelperTest.assertEquals((String)noSubst, (String)result);
    }

    public void testSubstVarsVariableNotClosed() {
        String noSubst = "testing if ${v1 works";
        try {
            String result = OptionHelper.substVars((String)noSubst, null, null);
            OptionHelperTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSubstVarsPrimaryOnly() {
        this.primaryMap.put("v1", "if");
        this.primaryMap.put("v2", "works");
        String result = OptionHelper.substVars((String)this.text, this.primaryMap, null);
        OptionHelperTest.assertEquals((String)this.expected, (String)result);
    }

    public void testSubstVarsPrimaryAndSecondary() {
        this.primaryMap.put("v1", "if");
        this.secondaryMap.put("v2", "works");
        String result = OptionHelper.substVars((String)this.text, this.primaryMap, this.secondaryMap);
        OptionHelperTest.assertEquals((String)this.expected, (String)result);
    }

    public void testSubstVarsSystemProperties() {
        System.setProperty("v1", "if");
        System.setProperty("v2", "works");
        String result = OptionHelper.substVars((String)this.text, null, null);
        OptionHelperTest.assertEquals((String)this.expected, (String)result);
        System.clearProperty("v1");
        System.clearProperty("v2");
    }

    public void testSubstVarsWithDefault() {
        this.primaryMap.put("v1", "if");
        String textWithDefault = "Testing ${v1} variable substitution ${v2:-toto}";
        String resultWithDefault = "Testing if variable substitution toto";
        String result = OptionHelper.substVars((String)textWithDefault, this.primaryMap, null);
        OptionHelperTest.assertEquals((String)resultWithDefault, (String)result);
    }

    public void testSubstVarsRecursive() {
        this.primaryMap.put("v1", "if");
        this.primaryMap.put("v2", "${v3}");
        this.primaryMap.put("v3", "works");
        String result = OptionHelper.substVars((String)this.text, this.primaryMap, null);
        OptionHelperTest.assertEquals((String)this.expected, (String)result);
    }
}

