/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Calendar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class FileNamePatternTest
extends TestCase {
    Context context = new ContextBase();

    public FileNamePatternTest(String arg) {
        super(arg);
    }

    public void test1() {
        FileNamePattern pp = new FileNamePattern("t", this.context);
        FileNamePatternTest.assertEquals((String)"t", (String)pp.convertInt(3));
        pp = new FileNamePattern("foo", this.context);
        FileNamePatternTest.assertEquals((String)"foo", (String)pp.convertInt(3));
        pp = new FileNamePattern("%i foo", this.context);
        StatusPrinter.print((StatusManager)this.context.getStatusManager());
        FileNamePatternTest.assertEquals((String)"3 foo", (String)pp.convertInt(3));
        pp = new FileNamePattern("foo%i.xixo", this.context);
        FileNamePatternTest.assertEquals((String)"foo3.xixo", (String)pp.convertInt(3));
        pp = new FileNamePattern("foo%i.log", this.context);
        FileNamePatternTest.assertEquals((String)"foo3.log", (String)pp.convertInt(3));
        pp = new FileNamePattern("foo.%i.log", this.context);
        FileNamePatternTest.assertEquals((String)"foo.3.log", (String)pp.convertInt(3));
        pp = new FileNamePattern("%i.foo\\%", this.context);
        FileNamePatternTest.assertEquals((String)"3.foo%", (String)pp.convertInt(3));
        pp = new FileNamePattern("\\%foo", this.context);
        FileNamePatternTest.assertEquals((String)"%foo", (String)pp.convertInt(3));
    }

    public void test2() {
        FileNamePattern pp = new FileNamePattern("foo%i\\_bar%i", this.context);
        FileNamePatternTest.assertEquals((String)"foo3bar3", (String)pp.convertInt(3));
    }

    public void test3() {
        Calendar cal = Calendar.getInstance();
        cal.set(2003, 4, 20, 17, 55);
        FileNamePattern pp = new FileNamePattern("foo%d{yyyy.MM.dd}", this.context);
        StatusPrinter.print((StatusManager)this.context.getStatusManager());
        FileNamePatternTest.assertEquals((String)"foo2003.05.20", (String)pp.convertDate(cal.getTime()));
        pp = new FileNamePattern("foo%d{yyyy.MM.dd HH:mm}", this.context);
        FileNamePatternTest.assertEquals((String)"foo2003.05.20 17:55", (String)pp.convertDate(cal.getTime()));
        pp = new FileNamePattern("%d{yyyy.MM.dd HH:mm} foo", this.context);
        FileNamePatternTest.assertEquals((String)"2003.05.20 17:55 foo", (String)pp.convertDate(cal.getTime()));
    }

    public static Test xsuite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new FileNamePatternTest("test1"));
        suite.addTest((Test)new FileNamePatternTest("test2"));
        return suite;
    }
}

