/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.rolling.DelayerUtil;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.Compare;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import junit.framework.TestCase;

public class RenamingTest
extends TestCase {
    Layout<Object> layout;
    Context context = new ContextBase();

    public RenamingTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.layout = new EchoLayout();
        File target = new File("src/test/output/test.log");
        target.mkdirs();
        target.delete();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRename() throws Exception {
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout(this.layout);
        rfa.setContext(this.context);
        rfa.setFile("src/test/output/test.log");
        String datePattern = "yyyy-MM-dd_HH_mm_ss";
        SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
        String[] filenames = new String[2];
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setFileNamePattern("src/test/output/test-%d{" + datePattern + "}");
        tbrp.setContext(this.context);
        tbrp.setParent((FileAppender)rfa);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        Calendar cal = Calendar.getInstance();
        rfa.doAppend((Object)"Hello 0");
        DelayerUtil.delayUntilNextSecond(50);
        rfa.doAppend((Object)"Hello 1");
        filenames[0] = "src/test/output/test-" + sdf.format(cal.getTime());
        filenames[1] = "src/test/output/test.log";
        for (int i = 0; i < filenames.length; ++i) {
            RenamingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/renaming." + i));
        }
    }
}

