/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.joran.spi.SimpleRuleStore;
import java.util.List;
import junit.framework.TestCase;
import org.xml.sax.Attributes;

public class SimpleStoreTest
extends TestCase {
    public SimpleStoreTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test1() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("a/b"), (Action)new XAction());
        List r = srs.matchActions(new Pattern("a/b"));
        SimpleStoreTest.assertNotNull((Object)r);
        SimpleStoreTest.assertEquals((int)1, (int)r.size());
        if (!(r.get(0) instanceof XAction)) {
            SimpleStoreTest.fail((String)"Wrong type");
        }
        srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("a/b"), (Action)new XAction());
        srs.addRule(new Pattern("a/b"), (Action)new YAction());
        r = srs.matchActions(new Pattern("a/b"));
        SimpleStoreTest.assertNotNull((Object)r);
        SimpleStoreTest.assertEquals((int)2, (int)r.size());
        if (!(r.get(0) instanceof XAction)) {
            SimpleStoreTest.fail((String)"Wrong type");
        }
        if (!(r.get(1) instanceof YAction)) {
            SimpleStoreTest.fail((String)"Wrong type");
        }
    }

    public void testSlashSuffix() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        Pattern pa = new Pattern("a/");
        srs.addRule(pa, (Action)new XAction());
        List r = srs.matchActions(new Pattern("a"));
        SimpleStoreTest.assertNotNull((Object)r);
        SimpleStoreTest.assertEquals((int)1, (int)r.size());
        if (!(r.get(0) instanceof XAction)) {
            SimpleStoreTest.fail((String)"Wrong type");
        }
    }

    public void testTail1() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("*/b"), (Action)new XAction());
        List r = srs.matchActions(new Pattern("a/b"));
        SimpleStoreTest.assertNotNull((Object)r);
        SimpleStoreTest.assertEquals((int)1, (int)r.size());
        if (!(r.get(0) instanceof XAction)) {
            SimpleStoreTest.fail((String)"Wrong type");
        }
    }

    public void testTail2() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("*/c"), (Action)new XAction());
        List r = srs.matchActions(new Pattern("a/b/c"));
        SimpleStoreTest.assertNotNull((Object)r);
        SimpleStoreTest.assertEquals((int)1, (int)r.size());
        if (!(r.get(0) instanceof XAction)) {
            SimpleStoreTest.fail((String)"Wrong type");
        }
    }

    public void testTail3() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("*/b"), (Action)new XAction());
        srs.addRule(new Pattern("*/a/b"), (Action)new YAction());
        List r = srs.matchActions(new Pattern("a/b"));
        SimpleStoreTest.assertNotNull((Object)r);
        SimpleStoreTest.assertEquals((int)1, (int)r.size());
        if (!(r.get(0) instanceof YAction)) {
            SimpleStoreTest.fail((String)"Wrong type");
        }
    }

    public void testTail4() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("*/b"), (Action)new XAction());
        srs.addRule(new Pattern("*/a/b"), (Action)new YAction());
        srs.addRule(new Pattern("a/b"), (Action)new ZAction());
        List r = srs.matchActions(new Pattern("a/b"));
        SimpleStoreTest.assertNotNull((Object)r);
        SimpleStoreTest.assertEquals((int)1, (int)r.size());
        if (!(r.get(0) instanceof ZAction)) {
            SimpleStoreTest.fail((String)"Wrong type");
        }
    }

    public void testSuffix() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("a"), (Action)new XAction());
        srs.addRule(new Pattern("a/*"), (Action)new YAction());
        List r = srs.matchActions(new Pattern("a/b"));
        SimpleStoreTest.assertNotNull((Object)r);
        SimpleStoreTest.assertEquals((int)1, (int)r.size());
        SimpleStoreTest.assertTrue((boolean)(r.get(0) instanceof YAction));
    }

    public void testDeepSuffix() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("a"), (Action)new XAction(1));
        srs.addRule(new Pattern("a/b/*"), (Action)new XAction(2));
        List r = srs.matchActions(new Pattern("a/other"));
        SimpleStoreTest.assertNull((Object)r);
    }

    public void testPrefixSuffixInteraction1() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("a"), (Action)new ZAction());
        srs.addRule(new Pattern("a/*"), (Action)new YAction());
        srs.addRule(new Pattern("*/a/b"), (Action)new XAction(3));
        List r = srs.matchActions(new Pattern("a/b"));
        SimpleStoreTest.assertNotNull((Object)r);
        SimpleStoreTest.assertEquals((int)1, (int)r.size());
        SimpleStoreTest.assertTrue((boolean)(r.get(0) instanceof XAction));
        XAction xaction = (XAction)((Object)r.get(0));
        SimpleStoreTest.assertEquals((int)3, (int)xaction.id);
    }

    public void testPrefixSuffixInteraction2() throws Exception {
        SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
        srs.addRule(new Pattern("testGroup"), (Action)new XAction());
        srs.addRule(new Pattern("testGroup/testShell"), (Action)new YAction());
        srs.addRule(new Pattern("testGroup/testShell/test"), (Action)new ZAction());
        srs.addRule(new Pattern("testGroup/testShell/test/*"), (Action)new XAction(9));
        List r = srs.matchActions(new Pattern("testGroup/testShell/toto"));
        SimpleStoreTest.assertNull((Object)r);
    }

    class ZAction
    extends Action {
        ZAction() {
        }

        public void begin(InterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(InterpretationContext ec, String name) {
        }

        public void finish(InterpretationContext ec) {
        }
    }

    class YAction
    extends Action {
        YAction() {
        }

        public void begin(InterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(InterpretationContext ec, String name) {
        }

        public void finish(InterpretationContext ec) {
        }
    }

    class XAction
    extends Action {
        int id = 0;

        XAction() {
        }

        XAction(int id) {
            this.id = id;
        }

        public void begin(InterpretationContext ec, String name, Attributes attributes) {
        }

        public void end(InterpretationContext ec, String name) {
        }

        public void finish(InterpretationContext ec) {
        }

        public String toString() {
            return "XAction(" + this.id + ")";
        }
    }
}

