/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.ScanException;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TokenStreamTest
extends TestCase {
    public TokenStreamTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEmpty() throws ScanException {
        List tl = new TokenStream("").tokenize();
        ArrayList witness = new ArrayList();
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testSingleLiteral() throws ScanException {
        List tl = new TokenStream("hello").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"hello"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testLiteralWithPercent() throws ScanException {
        List tl = new TokenStream("hello\\%world").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"hello%world"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("hello\\%").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"hello%"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("\\%").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"%"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testBasic() throws ScanException {
        List tl = new TokenStream("%c").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"c"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%a%b").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"a"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"b"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("xyz%-34c").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"xyz"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1002, (Object)"-34"));
        witness.add(new Token(1004, (Object)"c"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testComplexNR() throws ScanException {
        List tl = new TokenStream("%d{1234} [%34.-67toto] %n").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"d"));
        witness.add(new Token(1006, (Object)"1234"));
        witness.add(new Token(1000, (Object)" ["));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1002, (Object)"34.-67"));
        witness.add(new Token(1004, (Object)"toto"));
        witness.add(new Token(1000, (Object)"] "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"n"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testEmptyP() throws ScanException {
        List tl = new TokenStream("()").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"("));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testEmptyP2() throws ScanException {
        List tl = new TokenStream("%()").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(Token.LEFT_PARENTHESIS_TOKEN);
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testEscape() throws ScanException {
        List tl = new TokenStream("\\%").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"%"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("\\%\\(\\t\\)\\r\\n").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"%(\t)\r\n"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("\\\\%x").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"\\"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x\\)").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        witness.add(new Token(1000, (Object)")"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x\\_a").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        witness.add(new Token(1000, (Object)"a"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x\\_%b").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"b"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testOptions() throws ScanException {
        List tl = new TokenStream("%x{t}").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        witness.add(new Token(1006, (Object)"t"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x{t,y}").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        witness.add(new Token(1006, (Object)"t,y"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x{\"hello world.\", \"12y  \"}").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        witness.add(new Token(1006, (Object)"\"hello world.\", \"12y  \""));
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("%x{opt\\}}").tokenize();
        witness = new ArrayList();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"x"));
        witness.add(new Token(1006, (Object)"opt}"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testSimpleP() throws ScanException {
        List tl = new TokenStream("%(hello %class{.4?})").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(Token.LEFT_PARENTHESIS_TOKEN);
        witness.add(new Token(1000, (Object)"hello "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"class"));
        witness.add(new Token(1006, (Object)".4?"));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testSimpleP2() throws ScanException {
        List tl = new TokenStream("X %a %-12.550(hello %class{.4?})").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(new Token(1000, (Object)"X "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"a"));
        witness.add(new Token(1000, (Object)" "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1002, (Object)"-12.550"));
        witness.add(Token.LEFT_PARENTHESIS_TOKEN);
        witness.add(new Token(1000, (Object)"hello "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"class"));
        witness.add(new Token(1006, (Object)".4?"));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testMultipleRecursion() throws ScanException {
        List tl = new TokenStream("%-1(%d %45(%class %file))").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1002, (Object)"-1"));
        witness.add(Token.LEFT_PARENTHESIS_TOKEN);
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"d"));
        witness.add(new Token(1000, (Object)" "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1002, (Object)"45"));
        witness.add(Token.LEFT_PARENTHESIS_TOKEN);
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"class"));
        witness.add(new Token(1000, (Object)" "));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"file"));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }

    public void testNested() throws ScanException {
        List tl = new TokenStream("%(%a%(%b))").tokenize();
        ArrayList<Token> witness = new ArrayList<Token>();
        witness.add(Token.PERCENT_TOKEN);
        witness.add(Token.LEFT_PARENTHESIS_TOKEN);
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"a"));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(Token.LEFT_PARENTHESIS_TOKEN);
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"b"));
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        witness.add(Token.RIGHT_PARENTHESIS_TOKEN);
        TokenStreamTest.assertEquals(witness, (Object)tl);
        tl = new TokenStream("\\(%h\\)").tokenize();
        witness = new ArrayList();
        witness.add(new Token(1000, (Object)"("));
        witness.add(Token.PERCENT_TOKEN);
        witness.add(new Token(1004, (Object)"h"));
        witness.add(new Token(1000, (Object)")"));
        TokenStreamTest.assertEquals(witness, (Object)tl);
    }
}

