/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.IncompatibleClassException;
import java.util.Properties;

public class OptionHelper {
    static final String DELIM_START = "${";
    static final char DELIM_STOP = '}';
    static final int DELIM_START_LEN = 2;
    static final int DELIM_STOP_LEN = 1;

    public static Object instantiateByClassName(String className, Class superClass) throws ClassNotFoundException, IncompatibleClassException, InstantiationException, IllegalAccessException {
        if (className == null) {
            throw new NullPointerException();
        }
        Class<?> classObj = Class.forName(className);
        if (!superClass.isAssignableFrom(classObj)) {
            throw new IncompatibleClassException(superClass, classObj);
        }
        return classObj.newInstance();
    }

    public static String findAndSubst(String key, Properties props) {
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            return OptionHelper.substVars(value, props);
        }
        catch (IllegalArgumentException e) {
            return value;
        }
    }

    public static String substVars(String val, Properties props) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (true) {
            int j;
            if ((j = val.indexOf(DELIM_START, i)) == -1) {
                if (i == 0) {
                    return val;
                }
                sbuf.append(val.substring(i, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i, j));
            int k = val.indexOf(125, j);
            if (k == -1) {
                throw new IllegalArgumentException('\"' + val + "\" has no closing brace. Opening brace at position " + j + '.');
            }
            String rawKey = val.substring(j += 2, k);
            String[] extracted = OptionHelper.extractDefaultReplacement(rawKey);
            String key = extracted[0];
            String defaultReplacement = extracted[1];
            String replacement = null;
            if (props != null) {
                replacement = props.getProperty(key);
            }
            if (replacement == null) {
                replacement = OptionHelper.getSystemProperty(key, null);
            }
            if (replacement == null) {
                replacement = defaultReplacement;
            }
            if (replacement != null) {
                String recursiveReplacement = OptionHelper.substVars(replacement, props);
                sbuf.append(recursiveReplacement);
            }
            i = k + 1;
        }
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (Throwable e) {
            return def;
        }
    }

    public static String[] extractDefaultReplacement(String key) {
        String[] result = new String[2];
        result[0] = key;
        int d = key.indexOf(":-");
        if (d != -1) {
            result[0] = key.substring(0, d);
            result[1] = key.substring(d + 2);
        }
        return result;
    }

    public static boolean toBoolean(String value, boolean dEfault) {
        if (value == null) {
            return dEfault;
        }
        String trimmedVal = value.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return dEfault;
    }

    public static boolean isEmpty(String val) {
        return val == null || "".equals(val);
    }
}

