/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.spi.ContextAwareBase;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class RollingCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -5937537740925066161L;
    static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    public static final int TOP_OF_TROUBLE = -1;
    public static final int TOP_OF_SECOND = 0;
    public static final int TOP_OF_MINUTE = 1;
    public static final int TOP_OF_HOUR = 2;
    public static final int HALF_DAY = 3;
    public static final int TOP_OF_DAY = 4;
    public static final int TOP_OF_WEEK = 5;
    public static final int TOP_OF_MONTH = 6;
    int type = -1;

    public RollingCalendar() {
    }

    public RollingCalendar(TimeZone tz, Locale locale) {
        super(tz, locale);
    }

    public void init(String datePattern) {
        this.type = this.computeTriggeringPeriod(datePattern);
    }

    private void setType(int type) {
        this.type = type;
    }

    public long getNextCheckMillis(Date now) {
        return this.getNextCheckDate(now).getTime();
    }

    public int computeTriggeringPeriod(String datePattern) {
        RollingCalendar rollingCalendar = new RollingCalendar(GMT_TIMEZONE, Locale.getDefault());
        Date epoch = new Date(0L);
        if (datePattern != null) {
            for (int i = 0; i <= 6; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(datePattern);
                simpleDateFormat.setTimeZone(GMT_TIMEZONE);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    public void printPeriodicity(ContextAwareBase cab) {
        switch (this.type) {
            case 0: {
                cab.addInfo("Roll-over every second.");
                break;
            }
            case 1: {
                cab.addInfo("Roll-over every minute.");
                break;
            }
            case 2: {
                cab.addInfo("Roll-over at the top of every hour.");
                break;
            }
            case 3: {
                cab.addInfo("Roll-over at midday and midnight.");
                break;
            }
            case 4: {
                cab.addInfo("Roll-over at midnight.");
                break;
            }
            case 5: {
                cab.addInfo("Rollover at the start of week.");
                break;
            }
            case 6: {
                cab.addInfo("Rollover at start of every month.");
                break;
            }
            default: {
                cab.addInfo("Unknown periodicity.");
            }
        }
    }

    public Date getNextCheckDate(Date now) {
        this.setTime(now);
        switch (this.type) {
            case 0: {
                this.set(14, 0);
                this.add(13, 1);
                break;
            }
            case 1: {
                this.set(13, 0);
                this.set(14, 0);
                this.add(12, 1);
                break;
            }
            case 2: {
                this.set(12, 0);
                this.set(13, 0);
                this.set(14, 0);
                this.add(11, 1);
                break;
            }
            case 3: {
                this.set(12, 0);
                this.set(13, 0);
                this.set(14, 0);
                int hour = this.get(11);
                if (hour < 12) {
                    this.set(11, 12);
                    break;
                }
                this.set(11, 0);
                this.add(5, 1);
                break;
            }
            case 4: {
                this.set(11, 0);
                this.set(12, 0);
                this.set(13, 0);
                this.set(14, 0);
                this.add(5, 1);
                break;
            }
            case 5: {
                this.set(7, this.getFirstDayOfWeek());
                this.set(11, 0);
                this.set(13, 0);
                this.set(14, 0);
                this.add(3, 1);
                break;
            }
            case 6: {
                this.set(5, 1);
                this.set(11, 0);
                this.set(13, 0);
                this.set(14, 0);
                this.add(2, 1);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown periodicity type.");
            }
        }
        return this.getTime();
    }
}

