/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.Compress;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import java.io.File;

public class FixedWindowRollingPolicy
extends RollingPolicyBase {
    static final String FNP_NOT_SET = "The FileNamePattern option must be set before using FixedWindowRollingPolicy. ";
    static final String SEE_FNP_NOT_SET = "See also http://www.logback.com/doc/codes.html#tbr_fnp_not_set";
    int maxIndex = 7;
    int minIndex = 1;
    RenameUtil util = new RenameUtil();
    Compress compress = new Compress();
    private static int MAX_WINDOW_SIZE = 12;

    public FixedWindowRollingPolicy() {
        this.activeFileName = null;
    }

    public void start() {
        IntegerTokenConverter itc;
        this.util.setContext(this.context);
        this.compress.setContext(this.context);
        if (this.fileNamePatternStr == null) {
            this.addWarn(FNP_NOT_SET);
            this.addWarn(SEE_FNP_NOT_SET);
            throw new IllegalStateException("The FileNamePattern option must be set before using FixedWindowRollingPolicy. See also http://www.logback.com/doc/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr, this.context);
        this.determineCompressionMode();
        if (this.activeFileName == null) {
            this.addWarn("The ActiveFile name option must be set before using this rolling policy.");
            throw new IllegalStateException("The ActiveFileName option must be set.");
        }
        if (this.maxIndex < this.minIndex) {
            this.addWarn("MaxIndex (" + this.maxIndex + ") cannot be smaller than MinIndex (" + this.minIndex + ").");
            this.addWarn("Setting maxIndex to equal minIndex.");
            this.maxIndex = this.minIndex;
        }
        if (this.maxIndex - this.minIndex > MAX_WINDOW_SIZE) {
            this.addWarn("Large window sizes are not allowed.");
            this.maxIndex = this.minIndex + MAX_WINDOW_SIZE;
            this.addWarn("MaxIndex reduced to " + this.maxIndex);
        }
        if ((itc = this.fileNamePattern.getIntegerTokenConverter()) == null) {
            throw new IllegalStateException("FileNamePattern [" + this.fileNamePattern.getPattern() + "] does not contain a valid IntegerToken");
        }
    }

    public void rollover() throws RolloverFailure {
        if (this.maxIndex >= 0) {
            File file = new File(this.fileNamePattern.convertInt(this.maxIndex));
            if (file.exists()) {
                file.delete();
            }
            for (int i = this.maxIndex - 1; i >= this.minIndex; --i) {
                String toRenameStr = this.fileNamePattern.convertInt(i);
                File toRename = new File(toRenameStr);
                if (toRename.exists()) {
                    this.util.rename(toRenameStr, this.fileNamePattern.convertInt(i + 1));
                    continue;
                }
                this.addInfo("Skipping roll=over for inexistent file " + toRenameStr);
            }
            switch (this.compressionMode) {
                case 0: {
                    this.util.rename(this.activeFileName, this.fileNamePattern.convertInt(this.minIndex));
                    break;
                }
                case 1: {
                    this.compress.GZCompress(this.activeFileName, this.fileNamePattern.convertInt(this.minIndex));
                    break;
                }
                case 2: {
                    this.compress.ZIPCompress(this.activeFileName, this.fileNamePattern.convertInt(this.minIndex));
                }
            }
        }
    }

    public String getActiveFileName() {
        return this.activeFileName;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
    }

    public void setMinIndex(int minIndex) {
        this.minIndex = minIndex;
    }
}

