/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.KeywordNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

class Compiler {
    Converter head;
    Converter tail;
    final Node top;
    final Map converterMap;
    StatusManager statusManager;

    Compiler(Node top, Map converterMap) {
        this.top = top;
        this.converterMap = converterMap;
    }

    Converter compile() {
        this.tail = null;
        this.head = null;
        Node n = this.top;
        while (n != null) {
            switch (n.type) {
                case 0: {
                    this.addToList(new LiteralConverter((String)n.getValue()));
                    break;
                }
                case 2: {
                    CompositeNode cn = (CompositeNode)n;
                    CompositeConverter compositeConverter = new CompositeConverter();
                    compositeConverter.setFormattingInfo(cn.getFormatInfo());
                    Converter childConverter = new Compiler(cn.getChildNode(), this.converterMap).compile();
                    compositeConverter.setChildConverter(childConverter);
                    this.addToList(compositeConverter);
                    break;
                }
                case 1: {
                    KeywordNode kn = (KeywordNode)n;
                    DynamicConverter dynaConverter = this.createConverter(kn);
                    if (dynaConverter != null) {
                        dynaConverter.setFormattingInfo(kn.getFormatInfo());
                        dynaConverter.setOptionList(kn.getOptions());
                        this.addToList(dynaConverter);
                        break;
                    }
                    LiteralConverter errConveter = new LiteralConverter("%PARSER_ERROR_" + kn.getValue());
                    this.addStatus(new ErrorStatus("[" + kn.getValue() + "] is not a valid conversion word", this));
                    this.addToList(errConveter);
                }
            }
            n = n.next;
        }
        return this.head;
    }

    private void addToList(Converter c) {
        if (this.head == null) {
            this.head = this.tail = c;
        } else {
            this.tail.setNext(c);
            this.tail = c;
        }
    }

    DynamicConverter createConverter(KeywordNode kn) {
        String keyword = (String)kn.getValue();
        String converterClassStr = (String)this.converterMap.get(keyword);
        if (converterClassStr != null) {
            try {
                return (DynamicConverter)OptionHelper.instantiateByClassName(converterClassStr, DynamicConverter.class);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void setStatusManager(StatusManager statusManager) {
        this.statusManager = statusManager;
    }

    void addStatus(Status status) {
        if (this.statusManager != null) {
            this.statusManager.add(status);
        }
    }
}

