/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SimpleRuleStore
extends ContextAwareBase
implements RuleStore {
    HashMap<Pattern, List<Action>> rules = new HashMap();

    public SimpleRuleStore(Context context) {
        this.setContext(context);
    }

    public void addRule(Pattern pattern, Action action) {
        action.setContext(this.context);
        List<Action> a4p = this.rules.get(pattern);
        if (a4p == null) {
            a4p = new ArrayList<Action>();
            this.rules.put(pattern, a4p);
        }
        a4p.add(action);
    }

    public void addRule(Pattern pattern, String actionClassName) {
        Action action = null;
        try {
            action = (Action)OptionHelper.instantiateByClassName(actionClassName, Action.class);
        }
        catch (Exception e) {
            this.addError("Could not instantiate class [" + actionClassName + "]", e);
        }
        if (action != null) {
            this.addRule(pattern, action);
        }
    }

    public List matchActions(Pattern pattern) {
        ArrayList a4p = (ArrayList)this.rules.get(pattern);
        if (a4p != null) {
            return a4p;
        }
        Iterator<Pattern> patternsIterator = this.rules.keySet().iterator();
        int max = 0;
        Pattern longestMatch = null;
        while (patternsIterator.hasNext()) {
            int r;
            Pattern p = patternsIterator.next();
            if (p.size() <= 1 || !p.get(0).equals("*") || (r = pattern.tailMatch(p)) <= max) continue;
            max = r;
            longestMatch = p;
        }
        if (longestMatch != null) {
            return (ArrayList)this.rules.get(longestMatch);
        }
        return null;
    }
}

