/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.joran.spi.Interpreter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.OptionHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContext
extends ContextAwareBase {
    Stack<Object> objectStack;
    Map<String, Object> objectMap;
    Properties substitutionProperties;
    Interpreter joranInterpreter;

    public ExecutionContext(Interpreter joranInterpreter) {
        this.joranInterpreter = joranInterpreter;
        this.objectStack = new Stack();
        this.objectMap = new HashMap<String, Object>(5);
        this.substitutionProperties = new Properties();
    }

    public void addError(String msg, Object origin) {
        msg = this.updateLocationInfo(msg);
        this.addStatus(new ErrorStatus(msg, origin));
    }

    public void addError(String msg, Object origin, Exception e) {
        msg = this.updateLocationInfo(msg);
        this.addStatus(new ErrorStatus(msg, origin, e));
    }

    public void addWarn(String msg, Object origin) {
        msg = this.updateLocationInfo(msg);
        this.addStatus(new WarnStatus(msg, origin));
    }

    public void addWarn(String msg, Object origin, Exception e) {
        msg = this.updateLocationInfo(msg);
        this.addStatus(new WarnStatus(msg, origin, e));
    }

    public void addInfo(String msg, Object origin) {
        msg = this.updateLocationInfo(msg);
        this.addStatus(new InfoStatus(msg, origin));
    }

    String updateLocationInfo(String msg) {
        Locator locator = this.joranInterpreter.getLocator();
        if (locator != null) {
            return msg + locator.getLineNumber() + ":" + locator.getColumnNumber();
        }
        return msg;
    }

    public Locator getLocator() {
        return this.joranInterpreter.getLocator();
    }

    public Interpreter getJoranInterpreter() {
        return this.joranInterpreter;
    }

    public Stack<Object> getObjectStack() {
        return this.objectStack;
    }

    public Object peekObject() {
        return this.objectStack.peek();
    }

    public void pushObject(Object o) {
        this.objectStack.push(o);
    }

    public Object popObject() {
        return this.objectStack.pop();
    }

    public Object getObject(int i) {
        return this.objectStack.get(i);
    }

    public Map<String, Object> getObjectMap() {
        return this.objectMap;
    }

    public void addProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        value = value.trim();
        this.substitutionProperties.put(key, value);
    }

    public void addProperties(Properties props) {
        if (props == null) {
            return;
        }
        for (String string : props.keySet()) {
            this.addProperty(string, props.getProperty(string));
        }
    }

    public String getSubstitutionProperty(String key) {
        return this.substitutionProperties.getProperty(key);
    }

    public String subst(String value) {
        if (value == null) {
            return null;
        }
        return OptionHelper.substVars(value, this.substitutionProperties);
    }
}

