/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SimpleSocketServer;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.classic.spi.LoggerContextRemoteView;
import ch.qos.logback.classic.spi.LoggerRemoteView;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketAppenderTest {
    static final String LIST_APPENDER_NAME = "la";
    int port = 4561;
    LoggerContext lc = new LoggerContext();
    LoggerContext serverLC = new LoggerContext();
    ListAppender<LoggingEvent> la = new ListAppender();
    SocketAppender socketAppender = new SocketAppender();
    private SimpleSocketServer simpleSocketServer;

    @Test
    public void testStartFailNoRemoteHost() {
        SocketAppender appender = new SocketAppender();
        appender.setContext((Context)this.lc);
        appender.setPort(123);
        appender.start();
        Assert.assertEquals((long)1L, (long)this.lc.getStatusManager().getCount());
    }

    @Test
    public void testRecieveMessage() throws InterruptedException {
        this.fireServer();
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        logger.debug("test msg");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(2000L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        Assert.assertEquals((long)1L, (long)this.la.list.size());
        LoggingEvent remoteEvent = (LoggingEvent)this.la.list.get(0);
        Assert.assertEquals((Object)"test msg", (Object)remoteEvent.getMessage());
        Assert.assertEquals((Object)Level.DEBUG, (Object)remoteEvent.getLevel());
    }

    @Test
    public void testRecieveWithContext() throws InterruptedException {
        this.fireServer();
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        logger.debug("test msg");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(2000L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        Assert.assertEquals((long)1L, (long)this.la.list.size());
        LoggingEvent remoteEvent = (LoggingEvent)this.la.list.get(0);
        LoggerRemoteView loggerRemoteView = remoteEvent.getLoggerRemoteView();
        Assert.assertNotNull((Object)loggerRemoteView);
        Assert.assertEquals((Object)"root", (Object)loggerRemoteView.getName());
        LoggerContextRemoteView loggerContextRemoteView = loggerRemoteView.getLoggerContextView();
        Assert.assertNotNull((Object)loggerContextRemoteView);
        Assert.assertEquals((Object)"test", (Object)loggerContextRemoteView.getName());
        Map props = loggerContextRemoteView.getPropertyMap();
        Assert.assertEquals((Object)"testValue", props.get("testKey"));
    }

    @Test
    public void testMessageWithMDC() throws InterruptedException {
        this.fireServer();
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        MDC.put((String)"key", (String)"testValue");
        logger.debug("test msg");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(2000L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        ListAppender<LoggingEvent> la = this.getListAppender();
        Assert.assertEquals((long)1L, (long)la.list.size());
        LoggingEvent remoteEvent = (LoggingEvent)la.list.get(0);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assert.assertEquals((Object)"testValue", MDCPropertyMap.get("key"));
    }

    @Test
    public void testMessageWithMarker() throws InterruptedException {
        this.fireServer();
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        Marker marker = MarkerFactory.getMarker((String)"testMarker");
        logger.debug(marker, "test msg");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(2000L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        Assert.assertEquals((long)1L, (long)this.la.list.size());
        LoggingEvent remoteEvent = (LoggingEvent)this.la.list.get(0);
        Assert.assertEquals((Object)"testMarker", (Object)remoteEvent.getMarker().getName());
    }

    @Test
    public void testMessageWithUpdatedMDC() throws InterruptedException {
        this.fireServer();
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        MDC.put((String)"key", (String)"testValue");
        logger.debug("test msg");
        MDC.put((String)"key", (String)"updatedTestValue");
        logger.debug("test msg 2");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(2000L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        ListAppender<LoggingEvent> la = this.getListAppender();
        Assert.assertEquals((long)2L, (long)la.list.size());
        LoggingEvent remoteEvent = (LoggingEvent)la.list.get(1);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assert.assertEquals((Object)"updatedTestValue", MDCPropertyMap.get("key"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lateServerLaunch() throws InterruptedException {
        this.socketAppender.setReconnectionDelay(20);
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        logger.debug("test msg");
        this.fireServer();
        SimpleSocketServer simpleSocketServer = this.simpleSocketServer;
        synchronized (simpleSocketServer) {
            this.simpleSocketServer.wait(1000L);
        }
        Thread.yield();
        Thread.yield();
        logger.debug("test msg 2");
        Thread.yield();
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(2000L);
        StatusPrinter.print((Context)this.lc);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        Assert.assertEquals((long)1L, (long)this.la.list.size());
        LoggingEvent remoteEvent = (LoggingEvent)this.la.list.get(0);
        Assert.assertEquals((Object)"test msg 2", (Object)remoteEvent.getMessage());
        Assert.assertEquals((Object)Level.DEBUG, (Object)remoteEvent.getLevel());
    }

    private void fireServer() throws InterruptedException {
        Logger root = this.serverLC.getLogger("root");
        this.la.setName(LIST_APPENDER_NAME);
        this.la.setContext((Context)this.serverLC);
        this.la.start();
        root.addAppender(this.la);
        this.simpleSocketServer = new SimpleSocketServer(this.serverLC, this.port);
        this.simpleSocketServer.start();
        Thread.yield();
    }

    ListAppender<LoggingEvent> getListAppender() {
        Logger root = this.serverLC.getLogger("root");
        return (ListAppender)root.getAppender(LIST_APPENDER_NAME);
    }

    private void configureClient() {
        this.lc = new LoggerContext();
        this.lc.setName("test");
        this.lc.putProperty("testKey", "testValue");
        Logger root = this.lc.getLogger("root");
        this.socketAppender.setContext((Context)this.lc);
        this.socketAppender.setName("socket");
        this.socketAppender.setPort(this.port);
        this.socketAppender.setRemoteHost("localhost");
        root.addAppender((Appender)this.socketAppender);
        this.socketAppender.start();
    }
}

