/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.classic.net.mock.MockSocketServer;
import ch.qos.logback.classic.spi.LoggerContextRemoteView;
import ch.qos.logback.classic.spi.LoggerRemoteView;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import java.util.Map;
import junit.framework.TestCase;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SocketAppenderTest
extends TestCase {
    private LoggerContext lc;
    private MockSocketServer mockSocketServer;

    public void testStartFailNoRemoteHost() {
        this.lc = new LoggerContext();
        SocketAppender appender = new SocketAppender();
        appender.setContext((Context)this.lc);
        appender.setPort(123);
        appender.start();
        SocketAppenderTest.assertEquals((int)1, (int)this.lc.getStatusManager().getCount());
    }

    public void testRecieveMessage() throws InterruptedException {
        this.startServer(1);
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        logger.debug("test msg");
        this.mockSocketServer.join(2000L);
        SocketAppenderTest.assertTrue((boolean)this.mockSocketServer.isFinished());
        SocketAppenderTest.assertEquals((int)1, (int)this.mockSocketServer.getEventsList().size());
        LoggingEvent remoteEvent = this.mockSocketServer.getEventsList().get(0);
        SocketAppenderTest.assertEquals((String)"test msg", (String)remoteEvent.getMessage());
        SocketAppenderTest.assertEquals((Object)Level.DEBUG, (Object)remoteEvent.getLevel());
    }

    public void testRecieveWithContext() throws InterruptedException {
        this.startServer(1);
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        logger.debug("test msg");
        this.mockSocketServer.join(2000L);
        SocketAppenderTest.assertTrue((boolean)this.mockSocketServer.isFinished());
        SocketAppenderTest.assertEquals((int)1, (int)this.mockSocketServer.getEventsList().size());
        LoggingEvent remoteEvent = this.mockSocketServer.getEventsList().get(0);
        LoggerRemoteView loggerRemoteView = remoteEvent.getLoggerRemoteView();
        SocketAppenderTest.assertNotNull((Object)loggerRemoteView);
        SocketAppenderTest.assertEquals((String)"root", (String)loggerRemoteView.getName());
        LoggerContextRemoteView loggerContextRemoteView = loggerRemoteView.getLoggerContextView();
        SocketAppenderTest.assertNotNull((Object)loggerContextRemoteView);
        SocketAppenderTest.assertEquals((String)"test", (String)loggerContextRemoteView.getName());
        Map props = loggerContextRemoteView.getPropertyMap();
        SocketAppenderTest.assertEquals((String)"testValue", (String)((String)props.get("testKey")));
    }

    public void testMessageWithMDC() throws InterruptedException {
        this.startServer(1);
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        MDC.put((String)"key", (String)"testValue");
        logger.debug("test msg");
        this.mockSocketServer.join(2000L);
        SocketAppenderTest.assertTrue((boolean)this.mockSocketServer.isFinished());
        SocketAppenderTest.assertEquals((int)1, (int)this.mockSocketServer.getEventsList().size());
        LoggingEvent remoteEvent = this.mockSocketServer.getEventsList().get(0);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        SocketAppenderTest.assertEquals((String)"testValue", (String)((String)MDCPropertyMap.get("key")));
    }

    public void testMessageWithMarker() throws InterruptedException {
        this.startServer(1);
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        Marker marker = MarkerFactory.getMarker((String)"testMarker");
        logger.debug(marker, "test msg");
        this.mockSocketServer.join(2000L);
        SocketAppenderTest.assertTrue((boolean)this.mockSocketServer.isFinished());
        SocketAppenderTest.assertEquals((int)1, (int)this.mockSocketServer.getEventsList().size());
        LoggingEvent remoteEvent = this.mockSocketServer.getEventsList().get(0);
        SocketAppenderTest.assertEquals((String)"testMarker", (String)remoteEvent.getMarker().getName());
    }

    public void testMessageWithUpdatedMDC() throws InterruptedException {
        this.startServer(2);
        this.configureClient();
        Logger logger = this.lc.getLogger("root");
        MDC.put((String)"key", (String)"testValue");
        logger.debug("test msg");
        MDC.put((String)"key", (String)"updatedTestValue");
        logger.debug("test msg 2");
        this.mockSocketServer.join(2000L);
        SocketAppenderTest.assertTrue((boolean)this.mockSocketServer.isFinished());
        SocketAppenderTest.assertEquals((int)2, (int)this.mockSocketServer.getEventsList().size());
        LoggingEvent remoteEvent = this.mockSocketServer.getEventsList().get(1);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        SocketAppenderTest.assertEquals((String)"updatedTestValue", (String)((String)MDCPropertyMap.get("key")));
    }

    private void startServer(int expectedEventNumber) throws InterruptedException {
        this.mockSocketServer = new MockSocketServer(expectedEventNumber);
        this.mockSocketServer.start();
        Thread.sleep(100L);
    }

    private void configureClient() {
        this.lc = new LoggerContext();
        this.lc.setName("test");
        this.lc.setProperty("testKey", "testValue");
        Logger root = this.lc.getLogger("root");
        SocketAppender socketAppender = new SocketAppender();
        socketAppender.setContext((Context)this.lc);
        socketAppender.setName("socket");
        socketAppender.setPort(4560);
        socketAppender.setRemoteHost("localhost");
        root.addAppender((Appender)socketAppender);
        socketAppender.start();
    }
}

