/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextRemoteView;
import ch.qos.logback.classic.spi.LoggerRemoteView;
import ch.qos.logback.classic.spi.LoggingEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import junit.framework.TestCase;
import org.slf4j.MDC;

public class LoggingEventSerializationTest
extends TestCase {
    LoggerContext lc;
    Logger logger;
    ByteArrayOutputStream bos;
    ObjectOutputStream oos;
    ObjectInputStream inputStream;

    public void setUp() throws Exception {
        super.setUp();
        this.lc = new LoggerContext();
        this.lc.setName("testContext");
        this.logger = this.lc.getLogger("root");
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.lc = null;
        this.logger = null;
    }

    public void testBasic() throws Exception {
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
        LoggingEvent event = this.createLoggingEvent();
        this.oos.writeObject(event);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new ObjectInputStream(bis);
        LoggingEvent remoteEvent = (LoggingEvent)this.inputStream.readObject();
        LoggingEventSerializationTest.assertEquals((String)"test message", (String)remoteEvent.getMessage());
        LoggingEventSerializationTest.assertEquals((Object)Level.DEBUG, (Object)remoteEvent.getLevel());
    }

    public void testContext() throws Exception {
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
        this.lc.setProperty("testKey", "testValue");
        LoggingEvent event = this.createLoggingEvent();
        this.oos.writeObject(event);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new ObjectInputStream(bis);
        LoggingEvent remoteEvent = (LoggingEvent)this.inputStream.readObject();
        LoggerRemoteView loggerRemoteView = remoteEvent.getLoggerRemoteView();
        LoggingEventSerializationTest.assertNotNull((Object)loggerRemoteView);
        LoggingEventSerializationTest.assertEquals((String)"root", (String)loggerRemoteView.getName());
        LoggerContextRemoteView loggerContextRemoteView = loggerRemoteView.getLoggerContextView();
        LoggingEventSerializationTest.assertNotNull((Object)loggerContextRemoteView);
        LoggingEventSerializationTest.assertEquals((String)"testContext", (String)loggerContextRemoteView.getName());
        Map props = loggerContextRemoteView.getPropertyMap();
        LoggingEventSerializationTest.assertNotNull((Object)props);
        LoggingEventSerializationTest.assertEquals((String)"testValue", (String)((String)props.get("testKey")));
    }

    public void testMDC() throws Exception {
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
        MDC.put((String)"key", (String)"testValue");
        LoggingEvent event = this.createLoggingEvent();
        this.oos.writeObject(event);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new ObjectInputStream(bis);
        LoggingEvent remoteEvent = (LoggingEvent)this.inputStream.readObject();
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        LoggingEventSerializationTest.assertEquals((String)"testValue", (String)((String)MDCPropertyMap.get("key")));
    }

    public void testUpdatedMDC() throws Exception {
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
        MDC.put((String)"key", (String)"testValue");
        LoggingEvent event1 = this.createLoggingEvent();
        this.oos.writeObject(event1);
        MDC.put((String)"key", (String)"updatedTestValue");
        LoggingEvent event2 = this.createLoggingEvent();
        this.oos.writeObject(event2);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new ObjectInputStream(bis);
        this.inputStream.readObject();
        LoggingEvent remoteEvent2 = (LoggingEvent)this.inputStream.readObject();
        Map MDCPropertyMap = remoteEvent2.getMDCPropertyMap();
        LoggingEventSerializationTest.assertEquals((String)"updatedTestValue", (String)((String)MDCPropertyMap.get("key")));
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(((Object)((Object)this)).getClass().getName(), this.logger, Level.DEBUG, "test message", null, null);
        return le;
    }
}

