/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.net.SMTPAppender;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import javax.mail.Address;
import javax.mail.MessagingException;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPAppenderTest
extends TestCase {
    SMTPAppender appender;

    public void setUp() throws Exception {
        super.setUp();
        LoggerContext lc = new LoggerContext();
        this.appender = new SMTPAppender();
        this.appender.setContext((Context)lc);
        this.appender.setName("smtp");
        this.appender.setFrom("user@host.dom");
        this.appender.setLayout(SMTPAppenderTest.buildLayout(lc));
        this.appender.setSMTPHost("mail2.qos.ch");
        this.appender.setSubject("logging report");
        this.appender.addTo("sebastien.nospam@qos.ch");
        this.appender.start();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.appender = null;
    }

    public void testStart() {
        try {
            Address[] addressArray = this.appender.getMessage().getFrom();
            Address address = addressArray[0];
            SMTPAppenderTest.assertEquals((String)"user@host.dom", (String)address.toString());
            addressArray = null;
            address = null;
            addressArray = this.appender.getMessage().getAllRecipients();
            address = addressArray[0];
            SMTPAppenderTest.assertEquals((String)"sebastien.nospam@qos.ch", (String)address.toString());
            SMTPAppenderTest.assertEquals((String)"logging report", (String)this.appender.getSubject());
            SMTPAppenderTest.assertTrue((boolean)this.appender.isStarted());
        }
        catch (MessagingException ex) {
            SMTPAppenderTest.fail((String)"Unexpected exception.");
        }
    }

    public void testAppendNonTriggeringEvent() {
        LoggingEvent event = new LoggingEvent();
        event.setThreadName("thead name");
        event.setLevel(Level.DEBUG);
        this.appender.subAppend(event);
        SMTPAppenderTest.assertEquals((int)1, (int)this.appender.cb.length());
    }

    public void testEntryConditionsCheck() {
        this.appender.checkEntryConditions();
        SMTPAppenderTest.assertEquals((int)0, (int)this.appender.getContext().getStatusManager().getCount());
    }

    public void testEntryConditionsCheckNoMessage() {
        this.appender.setMessage(null);
        this.appender.checkEntryConditions();
        SMTPAppenderTest.assertEquals((int)1, (int)this.appender.getContext().getStatusManager().getCount());
    }

    public void setTriggeringPolicy() {
        this.appender.setEvaluator(null);
        this.appender.checkEntryConditions();
        SMTPAppenderTest.assertEquals((int)1, (int)this.appender.getContext().getStatusManager().getCount());
    }

    public void testEntryConditionsCheckNoLayout() {
        this.appender.setLayout(null);
        this.appender.checkEntryConditions();
        SMTPAppenderTest.assertEquals((int)1, (int)this.appender.getContext().getStatusManager().getCount());
    }

    private static Layout<LoggingEvent> buildLayout(LoggerContext lc) {
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)lc);
        layout.setFileHeader("Some header\n");
        layout.setPattern("%-4relative [%thread] %-5level %class - %msg%n");
        layout.setFileFooter("Some footer");
        layout.start();
        return layout;
    }
}

