/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.joran.action.IncludeFileAction;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import junit.framework.TestCase;

public class IncludeFileActionTest
extends TestCase {
    LoggerContext context;
    IncludeFileAction action;
    String redirectToFile = "src/test/input/joran/redirectToFile.xml";
    String redirectToURL = "src/test/input/joran/redirectToUrl.xml";
    String urlConfig = "http://logback.qos.ch/simpleConfig.xml";
    String simpleConfig = "src/test/input/joran/simpleConfig.xml";
    String invalidConfig = "src/test/input/joran/invalidConfig.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.context = new LoggerContext();
        this.action = new IncludeFileAction();
        this.action.setContext((Context)this.context);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.action = null;
        this.context = null;
    }

    public void testLoadFileOK() throws JoranException {
        System.setProperty("testing.value.file", this.simpleConfig);
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.context);
        jc.doConfigure(this.redirectToFile);
        this.verifyConfig();
    }

    public void testNoFileFound() throws JoranException {
        System.setProperty("testing.value.file", "toto");
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.context);
        jc.doConfigure(this.redirectToFile);
        IncludeFileActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getCount());
        IncludeFileActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getLevel());
    }

    public void testWithCorruptFile() throws JoranException {
        System.setProperty("testing.value.file", this.invalidConfig);
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.context);
        jc.doConfigure(this.redirectToFile);
        IncludeFileActionTest.assertEquals((int)10, (int)this.context.getStatusManager().getCount());
        IncludeFileActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getLevel());
    }

    public void testMalformedURL() throws JoranException {
        System.setProperty("testing.value.url", "htp://logback.qos.ch");
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.context);
        jc.doConfigure(this.redirectToURL);
        IncludeFileActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getCount());
        IncludeFileActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getLevel());
    }

    public void testUnknownURL() throws JoranException {
        System.setProperty("testing.value.url", "http://logback2345.qos.ch");
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.context);
        jc.doConfigure(this.redirectToURL);
        IncludeFileActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getCount());
        IncludeFileActionTest.assertEquals((int)2, (int)this.context.getStatusManager().getLevel());
    }

    private void verifyConfig() {
        Logger logger = this.context.getLogger("root");
        ConsoleAppender appender = (ConsoleAppender)logger.getAppender("redirectConsole");
        IncludeFileActionTest.assertNotNull((Object)appender);
        PatternLayout layout = (PatternLayout)appender.getLayout();
        IncludeFileActionTest.assertNotNull((Object)layout);
        IncludeFileActionTest.assertEquals((String)"%d - %m%n", (String)layout.getPattern());
    }
}

