/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.control;

import ch.qos.logback.classic.control.CreateLogger;
import ch.qos.logback.classic.control.RandomUtil;
import ch.qos.logback.classic.control.Scenario;
import java.util.LinkedList;

public class ScenarioMaker {
    private static final int AVERAGE_LOGGER_DEPTH = 4;
    private static final int LOGGER_DEPT_DEV = 2;

    public static Scenario makeTypeAScenario(int len) {
        Scenario scenario = new Scenario();
        for (int i = 0; i < len; ++i) {
            String loggerName = RandomUtil.randomLoggerName(4, 2);
            scenario.addAction(new CreateLogger(loggerName));
        }
        return scenario;
    }

    public static Scenario makeTypeBScenario(int len) {
        Scenario scenario = new Scenario();
        LinkedList<String> queue = new LinkedList<String>();
        int loggerCreationCount = 0;
        queue.add("");
        while (loggerCreationCount < len) {
            if (queue.isEmpty()) {
                throw new IllegalStateException("Queue cannot be empty.");
            }
            String loggerName = (String)queue.removeFirst();
            int childrenCount = RandomUtil.randomChildrenCount(loggerName);
            if (childrenCount == 0) {
                scenario.addAction(new CreateLogger(loggerName));
                ++loggerCreationCount;
                continue;
            }
            for (int i = 0; i < childrenCount; ++i) {
                String childName = loggerName.equals("") ? RandomUtil.randomId() : loggerName + '.' + RandomUtil.randomId();
                queue.add(childName);
            }
        }
        return scenario;
    }
}

