/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.PackagingDataCalculator;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableDataPoint;
import ch.qos.logback.classic.spi.ThrowableToDataPointArray;
import ch.qos.logback.core.CoreGlobal;
import java.io.Serializable;
import java.util.Arrays;

public class ThrowableProxy
implements Serializable {
    private static final long serialVersionUID = 6307784764626694851L;
    private ThrowableDataPoint[] tdpArray;
    private final transient Throwable throwable;
    private transient PackagingDataCalculator packagingDataCalculator;
    private boolean calculatedPackageData = false;

    public ThrowableProxy(Throwable throwable) {
        this.throwable = throwable;
        this.tdpArray = ThrowableToDataPointArray.convert(throwable);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public PackagingDataCalculator getPackagingDataCalculator() {
        if (this.throwable != null && this.packagingDataCalculator == null) {
            this.packagingDataCalculator = new PackagingDataCalculator();
        }
        return this.packagingDataCalculator;
    }

    public void calculatePackagingData() {
        if (this.calculatedPackageData) {
            return;
        }
        PackagingDataCalculator pdc = this.getPackagingDataCalculator();
        if (pdc != null) {
            this.calculatedPackageData = true;
            pdc.calculate(this.tdpArray);
        }
    }

    public ThrowableDataPoint[] getThrowableDataPointArray() {
        return this.tdpArray;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.tdpArray);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowableProxy other = (ThrowableProxy)obj;
        return Arrays.equals(this.tdpArray, other.tdpArray);
    }

    public void fullDump() {
        StringBuilder builder = new StringBuilder();
        for (ThrowableDataPoint tdp : this.getThrowableDataPointArray()) {
            String string = tdp.toString();
            builder.append(string);
            this.extraData(builder, tdp);
            builder.append(CoreGlobal.LINE_SEPARATOR);
        }
        System.out.println(builder.toString());
    }

    protected void extraData(StringBuilder builder, ThrowableDataPoint tdp) {
        ClassPackagingData cpd;
        StackTraceElementProxy step = tdp.getStackTraceElementProxy();
        if (step != null && (cpd = step.getClassPackagingData()) != null) {
            if (!cpd.isExact()) {
                builder.append(" ~[");
            } else {
                builder.append(" [");
            }
            builder.append(cpd.getCodeLocation()).append(':').append(cpd.getVersion()).append(']');
        }
    }
}

