/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.ClassicGlobal;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.mock.MockInitialContext;
import ch.qos.logback.classic.net.mock.MockInitialContextFactory;
import ch.qos.logback.classic.selector.ContextDetachingSCLTest;
import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.ContextSelector;
import junit.framework.TestCase;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class ContextJNDISelectorTest
extends TestCase {
    static String INITIAL_CONTEXT_KEY = "java.naming.factory.initial";

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("logback.ContextSelector", "JNDI");
        StaticLoggerBinder.SINGLETON.initialize();
        MockInitialContextFactory.initialize();
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put(ClassicGlobal.JNDI_CONTEXT_NAME, "toto");
        System.setProperty(INITIAL_CONTEXT_KEY, MockInitialContextFactory.class.getName());
        LoggerFactory.getLogger(ContextDetachingSCLTest.class);
    }

    protected void tearDown() throws Exception {
        System.clearProperty(INITIAL_CONTEXT_KEY);
        super.tearDown();
    }

    public void testGetExistingContext() {
        ContextSelector selector = StaticLoggerBinder.SINGLETON.getContextSelector();
        LoggerContext context = selector.getLoggerContext();
        ContextJNDISelectorTest.assertEquals((String)"toto", (String)context.getName());
    }

    public void testCreateContext() {
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put(ClassicGlobal.JNDI_CONTEXT_NAME, "tata");
        LoggerFactory.getLogger(ContextDetachingSCLTest.class);
        ContextJNDISelector selector = (ContextJNDISelector)StaticLoggerBinder.SINGLETON.getContextSelector();
        LoggerContext context = selector.getLoggerContext();
        ContextJNDISelectorTest.assertEquals((String)"tata", (String)context.getName());
        ContextJNDISelectorTest.assertEquals((int)1, (int)selector.getCount());
    }

    public void testReturnDefaultContext() {
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put(ClassicGlobal.JNDI_CONTEXT_NAME, null);
        ContextJNDISelector selector = (ContextJNDISelector)StaticLoggerBinder.SINGLETON.getContextSelector();
        LoggerContext context = selector.getLoggerContext();
        ContextJNDISelectorTest.assertEquals((String)"default", (String)context.getName());
    }
}

