/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.LRUCache;
import ch.qos.logback.classic.pattern.Simulator;
import ch.qos.logback.classic.pattern.lru.Event;
import ch.qos.logback.classic.pattern.lru.T_LRUCache;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class LRUCacheTest {
    @Test
    public void smoke() {
        LRUCache cache = new LRUCache(2);
        cache.put((Object)"a", (Object)"a");
        cache.put((Object)"b", (Object)"b");
        cache.put((Object)"c", (Object)"c");
        LinkedList<String> witness = new LinkedList<String>();
        witness.add("b");
        witness.add("c");
        Assert.assertEquals(witness, (Object)cache.keyList());
    }

    @Test
    public void typicalScenarioTest() {
        int simulationLen = 10000;
        int cacheSize = 100;
        int worldSize = 1000;
        this.doScenario(simulationLen, cacheSize, worldSize);
    }

    @Test
    public void scenarioCoverageTest() {
        int simulationLen = 10000;
        int[] cacheSizes = new int[]{1, 10, 100};
        int[] worldSizes = new int[]{1, 10, 100};
        for (int i = 0; i < cacheSizes.length; ++i) {
            for (int j = 0; j < worldSizes.length; ++j) {
                this.doScenario(simulationLen, cacheSizes[i], worldSizes[j]);
            }
        }
    }

    void doScenario(int simulationLen, int cacheSize, int worldSize) {
        int get2PutRatio = 10;
        Simulator simulator = new Simulator(worldSize, get2PutRatio, false);
        List<Event> scenario = simulator.generateScenario(simulationLen);
        LRUCache lruCache = new LRUCache(cacheSize);
        T_LRUCache<String> tlruCache = new T_LRUCache<String>(cacheSize);
        long start = System.nanoTime();
        simulator.simulate(scenario, (LRUCache<String, String>)lruCache, tlruCache);
        long end = System.nanoTime();
        System.out.println("cacheSize=" + cacheSize + ", worldSize=" + worldSize + ", elapsed time=" + (end - start) / 1000000L + " in millis");
    }

    @Test
    @Ignore
    public void multiThreadedScenario() throws InterruptedException {
        int i;
        int cacheSize = 100;
        int worldSize = cacheSize * 2;
        LRUCache lruCache = new LRUCache(cacheSize);
        T_LRUCache<String> tlruCache = new T_LRUCache<String>(cacheSize);
        SimulatorRunnable[] simulatorArray = new SimulatorRunnable[5];
        for (i = 0; i < simulatorArray.length; ++i) {
            simulatorArray[i] = new SimulatorRunnable((LRUCache<String, String>)lruCache, tlruCache, worldSize);
        }
        for (i = 0; i < simulatorArray.length; ++i) {
            simulatorArray[i].start();
        }
        for (i = 0; i < simulatorArray.length; ++i) {
            simulatorArray[i].join();
        }
        Assert.assertEquals(tlruCache.keyList(), (Object)lruCache.keyList());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimulatorRunnable
    extends Thread {
        LRUCache<String, String> lruCache;
        T_LRUCache<String> tlruCache;
        int worldSize;

        SimulatorRunnable(LRUCache<String, String> lruCache, T_LRUCache<String> tlruCache, int worldSize) {
            this.lruCache = lruCache;
            this.tlruCache = tlruCache;
            this.worldSize = worldSize;
        }

        @Override
        public void run() {
            int get2PutRatio = 10;
            int simulationLen = 50000;
            Simulator simulator = new Simulator(this.worldSize, get2PutRatio, true);
            List<Event> scenario = simulator.generateScenario(simulationLen);
            simulator.simulate(scenario, this.lruCache, this.tlruCache);
            System.out.println("done");
        }
    }
}

