/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.NoFilter;
import ch.qos.logback.classic.YesFilter;
import ch.qos.logback.classic.turbo.MarkerFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import junit.framework.TestCase;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TurboFilteringInLoggerTest
extends TestCase {
    static final String BLUE = "BLUE";
    LoggerContext context;
    Logger logger;
    Marker blueMarker = MarkerFactory.getMarker((String)"BLUE");

    protected void setUp() throws Exception {
        super.setUp();
        this.context = new LoggerContext();
        this.context.setName("test");
        this.context.start();
        this.logger = this.context.getLogger(TurboFilteringInLoggerTest.class);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void addYesFilter() {
        YesFilter filter = new YesFilter();
        filter.start();
        this.context.addTurboFilter((TurboFilter)filter);
    }

    private void addNoFilter() {
        NoFilter filter = new NoFilter();
        filter.start();
        this.context.addTurboFilter((TurboFilter)filter);
    }

    private void addAcceptBLUEFilter() {
        MarkerFilter filter = new MarkerFilter();
        filter.setMarker(BLUE);
        filter.setOnMatch("ACCEPT");
        filter.start();
        this.context.addTurboFilter((TurboFilter)filter);
    }

    private void addDenyBLUEFilter() {
        MarkerFilter filter = new MarkerFilter();
        filter.setMarker(BLUE);
        filter.setOnMatch("DENY");
        filter.start();
        this.context.addTurboFilter((TurboFilter)filter);
    }

    public void testIsDebugEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.INFO);
        TurboFilteringInLoggerTest.assertTrue((boolean)this.logger.isDebugEnabled());
    }

    public void testIsInfoEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.WARN);
        TurboFilteringInLoggerTest.assertTrue((boolean)this.logger.isInfoEnabled());
    }

    public void testIsWarnEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.ERROR);
        TurboFilteringInLoggerTest.assertTrue((boolean)this.logger.isWarnEnabled());
    }

    public void testIsErrorEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.OFF);
        TurboFilteringInLoggerTest.assertTrue((boolean)this.logger.isErrorEnabled());
    }

    public void testIsEnabledForWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.ERROR);
        TurboFilteringInLoggerTest.assertTrue((boolean)this.logger.isEnabledFor(Level.INFO));
    }

    public void testIsEnabledForWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        TurboFilteringInLoggerTest.assertFalse((boolean)this.logger.isEnabledFor(Level.INFO));
    }

    public void testIsDebugEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        TurboFilteringInLoggerTest.assertFalse((boolean)this.logger.isDebugEnabled());
    }

    public void testIsInfoEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        TurboFilteringInLoggerTest.assertFalse((boolean)this.logger.isInfoEnabled());
    }

    public void testIsWarnEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        TurboFilteringInLoggerTest.assertFalse((boolean)this.logger.isWarnEnabled());
    }

    public void testIsErrorEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        TurboFilteringInLoggerTest.assertFalse((boolean)this.logger.isErrorEnabled());
    }

    public void testIsErrorEnabledWithAcceptBlueFilter() {
        this.addAcceptBLUEFilter();
        this.logger.setLevel(Level.ERROR);
        TurboFilteringInLoggerTest.assertTrue((boolean)this.logger.isDebugEnabled(this.blueMarker));
    }

    public void testIsErrorEnabledWithDenyBlueFilter() {
        this.addDenyBLUEFilter();
        this.logger.setLevel(Level.ALL);
        TurboFilteringInLoggerTest.assertFalse((boolean)this.logger.isDebugEnabled(this.blueMarker));
    }

    public void testLoggingContextShutdownAndReset() {
        this.addYesFilter();
        TurboFilteringInLoggerTest.assertNotNull((Object)this.context.getFirstTurboFilter());
        this.context.shutdownAndReset();
        TurboFilteringInLoggerTest.assertNull((Object)this.context.getFirstTurboFilter());
    }
}

