/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.NOPTurboFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.appender.NOPAppender;
import ch.qos.logback.core.testUtil.Env;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.helpers.BogoPerf;

public class LoggerPerfTest {
    long NANOS_IN_ONE_SEC = 1000000000L;
    static long NORMAL_RUN_LENGTH = 1000000L;
    static long SHORTENED_RUN_LENGTH = 500000L;
    static long REFERENCE_BIPS = 9000L;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testDurationOfDisabledLogWithStraightStringParameter() {
        this.computeDurationOfDisabledLogWithStraightStringParameter(NORMAL_RUN_LENGTH);
        double avg = this.computeDurationOfDisabledLogWithStraightStringParameter(NORMAL_RUN_LENGTH);
        long referencePerf = 17L;
        BogoPerf.assertDuration((double)avg, (long)referencePerf, (double)REFERENCE_BIPS);
    }

    double computeDurationOfDisabledLogWithStraightStringParameter(long len) {
        LoggerContext lc = new LoggerContext();
        Logger logger = lc.getLogger(this.getClass());
        logger.setLevel(Level.OFF);
        for (long i = 0L; i < len; ++i) {
            logger.debug("Toto");
        }
        long start = System.nanoTime();
        for (long i = 0L; i < len; ++i) {
            logger.debug("Toto");
        }
        long end = System.nanoTime();
        return (end - start) / len;
    }

    @Test
    public void testDurationOfDisabledLogWithParameters() {
        this.computeDurationOfDisabledLogWithParameters(NORMAL_RUN_LENGTH);
        double avgDuration = this.computeDurationOfDisabledLogWithParameters(NORMAL_RUN_LENGTH);
        long referencePerf = 36L;
        BogoPerf.assertDuration((double)avgDuration, (long)referencePerf, (double)REFERENCE_BIPS);
    }

    double computeDurationOfDisabledLogWithParameters(long len) {
        LoggerContext lc = new LoggerContext();
        Logger logger = lc.getLogger(this.getClass());
        logger.setLevel(Level.OFF);
        for (long i = 0L; i < len; ++i) {
            logger.debug("Toto {}", (Object)i);
        }
        long start = System.nanoTime();
        for (long i = 0L; i < len; ++i) {
            logger.debug("Toto {}", (Object)i);
        }
        long end = System.nanoTime();
        return (end - start) / len;
    }

    @Test
    public void testDurationOfEnabledLog() {
        if (Env.isLinux()) {
            return;
        }
        this.computeDurationOfEnabledLog(SHORTENED_RUN_LENGTH);
        double avgDuration = this.computeDurationOfEnabledLog(SHORTENED_RUN_LENGTH);
        long referencePerf = 500L;
        BogoPerf.assertDuration((double)avgDuration, (long)referencePerf, (double)REFERENCE_BIPS);
    }

    double computeDurationOfEnabledLog(long len) {
        LoggerContext lc = new LoggerContext();
        Logger logger = lc.getLogger(this.getClass());
        logger.setLevel(Level.ALL);
        NOPAppender nopAppender = new NOPAppender();
        nopAppender.start();
        logger.addAppender((Appender)nopAppender);
        for (long i = 0L; i < len; ++i) {
            logger.debug("Toto");
        }
        long start = System.nanoTime();
        for (long i = 0L; i < len; ++i) {
            logger.debug("Toto");
        }
        long end = System.nanoTime();
        return (end - start) / len;
    }

    @Test
    public void testComputeDurationOfDisabledLogsWithNOPFilter() {
        this.computeDurationOfDisabledLogsWithNOPFilter(NORMAL_RUN_LENGTH);
        double avg = this.computeDurationOfDisabledLogsWithNOPFilter(NORMAL_RUN_LENGTH);
        long referencePerf = 48L;
        BogoPerf.assertDuration((double)avg, (long)referencePerf, (double)REFERENCE_BIPS);
    }

    double computeDurationOfDisabledLogsWithNOPFilter(long len) {
        LoggerContext lc = new LoggerContext();
        NOPAppender mopAppender = new NOPAppender();
        NOPTurboFilter nopFilter = new NOPTurboFilter();
        nopFilter.setName("nop");
        mopAppender.start();
        lc.addTurboFilter((TurboFilter)nopFilter);
        Logger logger = lc.getLogger(this.getClass());
        logger.setLevel(Level.OFF);
        for (long i = 0L; i < len; ++i) {
            logger.debug("Toto");
        }
        long start = System.nanoTime();
        for (long i = 0L; i < len; ++i) {
            logger.debug("Toto");
        }
        long end = System.nanoTime();
        return (end - start) / len;
    }

    @Test
    public void testThreadedLogging() throws InterruptedException {
        LoggerContext lc = new LoggerContext();
        SleepAppender appender = new SleepAppender();
        int MILLIS_PER_CALL = 250;
        int NANOS_PER_CALL = 250000000;
        appender.setDuration(MILLIS_PER_CALL);
        appender.start();
        Logger logger = lc.getLogger(this.getClass());
        logger.addAppender(appender);
        logger.setLevel(Level.DEBUG);
        int threadCount = 10;
        int iterCount = 5;
        TestRunner[] threads = new TestRunner[threadCount];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new TestRunner(logger, iterCount);
        }
        long start = System.nanoTime();
        for (TestRunner thread : threads) {
            thread.start();
        }
        for (TestRunner thread : threads) {
            thread.join();
        }
        long end = System.nanoTime();
        double tolerance = (double)threadCount * 0.125;
        double max = (double)NANOS_PER_CALL / (double)this.NANOS_IN_ONE_SEC * (double)iterCount * tolerance;
        double serialized = (double)NANOS_PER_CALL / (double)this.NANOS_IN_ONE_SEC * (double)iterCount * (double)threadCount;
        double actual = (double)(end - start) / (double)this.NANOS_IN_ONE_SEC;
        System.out.printf("Sleep duration: %,.4f seconds. Max expected: %,.4f seconds, Serialized: %,.4f\n", actual, max, serialized);
        Assert.assertTrue((String)"Exceeded maximum expected time.", (actual < max ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SleepAppender<E>
    extends UnsynchronizedAppenderBase<E> {
        private static long duration = 500L;

        public void setDuration(long millis) {
            duration = millis;
        }

        protected void append(E eventObject) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class TestRunner
    extends Thread {
        private Logger logger;
        private long len;

        public TestRunner(Logger logger, long len) {
            this.logger = logger;
            this.len = len;
        }

        public void run() {
            Thread.yield();
            for (long i = 0L; i < this.len; ++i) {
                this.logger.debug("Toto");
            }
        }
    }
}

