/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.control.ControlAction;
import ch.qos.logback.classic.control.ControlLogger;
import ch.qos.logback.classic.control.ControlLoggerContext;
import ch.qos.logback.classic.control.CreateLogger;
import ch.qos.logback.classic.control.Scenario;
import ch.qos.logback.classic.control.ScenarioMaker;
import ch.qos.logback.classic.control.SetLevel;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class DynamicLoggerContextTest {
    LoggerContext lc;

    @Test
    public void test3() {
        this.dynaTest(3);
    }

    @Test
    public void test30() {
        this.dynaTest(30);
    }

    @Test
    public void test1000() {
        this.dynaTest(1000);
    }

    private void dynaTest(int len) {
        LoggerContext lc = new LoggerContext();
        ControlLoggerContext controlContext = new ControlLoggerContext();
        Scenario s = ScenarioMaker.makeTypeBScenario(len);
        List<ControlAction> actionList = s.getActionList();
        int size = actionList.size();
        for (int i = 0; i < size; ++i) {
            ControlAction action = actionList.get(i);
            if (action instanceof CreateLogger) {
                CreateLogger cl = (CreateLogger)action;
                lc.getLogger(cl.getLoggerName());
                controlContext.getLogger(cl.getLoggerName());
                continue;
            }
            SetLevel sl = (SetLevel)action;
            Logger l = lc.getLogger(sl.getLoggerName());
            ControlLogger controlLogger = controlContext.getLogger(sl.getLoggerName());
            l.setLevel(sl.getLevel());
            controlLogger.setLevel(sl.getLevel());
        }
        this.compare(controlContext, lc);
    }

    void compare(ControlLoggerContext controlLC, LoggerContext lc) {
        Map controlLoggerMap = controlLC.getLoggerMap();
        Assert.assertEquals((long)(controlLoggerMap.size() + 1), (long)lc.size());
        for (String loggerName : controlLoggerMap.keySet()) {
            Logger logger = lc.exists(loggerName);
            ControlLogger controlLogger = (ControlLogger)((Object)controlLoggerMap.get(loggerName));
            if (logger == null) {
                throw new IllegalStateException("HLoggerr" + loggerName + " should exist");
            }
            Assert.assertEquals((Object)loggerName, (Object)logger.getName());
            Assert.assertEquals((Object)loggerName, (Object)controlLogger.getName());
            this.assertCompare(controlLogger, logger);
        }
    }

    void assertCompare(ControlLogger controlLogger, Logger logger) {
        Assert.assertEquals((Object)controlLogger.getName(), (Object)logger.getName());
        Assert.assertEquals((Object)controlLogger.getEffectiveLevel(), (Object)logger.getEffectiveLevel());
        Level controlLevel = controlLogger.getLevel();
        Level level = logger.getLevel();
        if (controlLevel == null) {
            Assert.assertNull((Object)level);
        } else {
            Assert.assertEquals((Object)controlLevel, (Object)level);
        }
    }
}

