/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.HashMap;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MDC;
import org.slf4j.impl.CopyOnInheritThreadLocal;
import org.slf4j.impl.LogbackMDCAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogbackMDCAdapterTest {
    static final String A_SUFFIX = "A_SUFFIX";
    int diff = new Random().nextInt();

    @Test
    public void copyOnInheritence() throws InterruptedException {
        String mdcKey = "x" + this.diff;
        String otherMDCKey = "o" + this.diff;
        MDC.put((String)mdcKey, (String)(mdcKey + A_SUFFIX));
        HashMap<String, String> parentHM = this.getHM();
        MyThread myThread = new MyThread(mdcKey, otherMDCKey);
        myThread.start();
        myThread.join();
        Assert.assertNull((Object)MDC.get((String)otherMDCKey));
        Assert.assertTrue((boolean)myThread.successul);
        Assert.assertTrue((parentHM != myThread.childHM ? 1 : 0) != 0);
    }

    HashMap<String, String> getHM() {
        LogbackMDCAdapter lma = (LogbackMDCAdapter)MDC.getMDCAdapter();
        CopyOnInheritThreadLocal copyOnInheritThreadLocal = lma.copyOnInheritThreadLocal;
        return (HashMap)copyOnInheritThreadLocal.get();
    }

    class MyThread
    extends Thread {
        String mdcKey;
        String otherMDCKey;
        boolean successul;
        HashMap<String, String> childHM;

        MyThread(String mdcKey, String otherMDCKey) {
            this.mdcKey = mdcKey;
            this.otherMDCKey = otherMDCKey;
        }

        public void run() {
            this.childHM = LogbackMDCAdapterTest.this.getHM();
            MDC.put((String)this.otherMDCKey, (String)(this.otherMDCKey + LogbackMDCAdapterTest.A_SUFFIX));
            Assert.assertNotNull((Object)MDC.get((String)this.mdcKey));
            Assert.assertEquals((Object)(this.mdcKey + LogbackMDCAdapterTest.A_SUFFIX), (Object)MDC.get((String)this.mdcKey));
            Assert.assertEquals((Object)(this.otherMDCKey + LogbackMDCAdapterTest.A_SUFFIX), (Object)MDC.get((String)this.otherMDCKey));
            this.successul = true;
        }
    }
}

