/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.MarkerConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import junit.framework.TestCase;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarkerFactory;

public class MarkerConverterTest
extends TestCase {
    LoggerContext lc;
    MarkerConverter converter;
    IMarkerFactory markerFactory = new BasicMarkerFactory();

    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.converter = new MarkerConverter();
        this.converter.start();
    }

    public void tearDown() throws Exception {
        this.lc = null;
        this.converter.stop();
        this.converter = null;
    }

    public void testWithNullMarker() {
        String result = this.converter.convert(this.createLoggingEvent(null));
        MarkerConverterTest.assertEquals((String)"", (String)result);
    }

    public void testWithMarker() {
        String name = "test";
        Marker marker = this.markerFactory.getMarker(name);
        String result = this.converter.convert(this.createLoggingEvent(marker));
        MarkerConverterTest.assertEquals((String)name, (String)result);
    }

    public void testWithOneChildMarker() {
        Marker marker = this.markerFactory.getMarker("test");
        marker.add(this.markerFactory.getMarker("child"));
        String result = this.converter.convert(this.createLoggingEvent(marker));
        MarkerConverterTest.assertEquals((String)"test [ child ]", (String)result);
    }

    public void testWithSeveralChildMarker() {
        Marker marker = this.markerFactory.getMarker("testParent");
        marker.add(this.markerFactory.getMarker("child1"));
        marker.add(this.markerFactory.getMarker("child2"));
        marker.add(this.markerFactory.getMarker("child3"));
        String result = this.converter.convert(this.createLoggingEvent(marker));
        MarkerConverterTest.assertEquals((String)"testParent [ child1, child2, child3 ]", (String)result);
    }

    private LoggingEvent createLoggingEvent(Marker marker) {
        LoggingEvent le = new LoggingEvent(((Object)((Object)this)).getClass().getName(), this.lc.getLogger("root"), Level.DEBUG, "test message", null, null);
        le.setMarker(marker);
        return le;
    }
}

