/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerRemoteView;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Logger
implements org.slf4j.Logger,
AppenderAttachable<LoggingEvent>,
Serializable {
    private static final long serialVersionUID = 5454405123156820674L;
    public static final String FQCN = Logger.class.getName();
    static int instanceCount = 0;
    private String name;
    private Level level;
    private int effectiveLevelInt;
    private Logger parent;
    private List<Logger> childrenList;
    private transient AppenderAttachableImpl<LoggingEvent> aai;
    private boolean additive = true;
    final transient LoggerContext loggerContext;
    LoggerRemoteView loggerRemoteView;
    private static final int DEFAULT_CHILD_ARRAY_SIZE = 5;

    Logger(String name, Logger parent, LoggerContext loggerContext) {
        this.name = name;
        this.parent = parent;
        this.loggerContext = loggerContext;
        this.buildRemoteView();
        ++instanceCount;
    }

    public final Level getEffectiveLevel() {
        return Level.toLevel(this.effectiveLevelInt);
    }

    int getEffectiveLevelInt() {
        return this.effectiveLevelInt;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    private final boolean isRootLogger() {
        return this.parent == null;
    }

    Logger getChildBySuffix(String suffix) {
        if (this.childrenList == null) {
            return null;
        }
        int len = this.childrenList.size();
        int childNameOffset = this.isRootLogger() ? 0 : this.name.length() + 1;
        for (int i = 0; i < len; ++i) {
            Logger childLogger = this.childrenList.get(i);
            String childName = childLogger.getName();
            if (!suffix.equals(childName.substring(childNameOffset))) continue;
            return childLogger;
        }
        return null;
    }

    Logger getChildByName(String childName) {
        if (this.childrenList == null) {
            return null;
        }
        int len = this.childrenList.size();
        for (int i = 0; i < len; ++i) {
            Logger childLogger_i = this.childrenList.get(i);
            String childName_i = childLogger_i.getName();
            if (!childName.equals(childName_i)) continue;
            return childLogger_i;
        }
        return null;
    }

    public synchronized void setLevel(Level newLevel) {
        if (this.level == newLevel) {
            return;
        }
        this.level = newLevel;
        this.effectiveLevelInt = newLevel.levelInt;
        if (this.childrenList != null) {
            int len = this.childrenList.size();
            for (int i = 0; i < len; ++i) {
                Logger child = this.childrenList.get(i);
                child.handleParentLevelChange(newLevel);
            }
        }
    }

    private synchronized void handleParentLevelChange(Level newParentLevel) {
        if (this.level == null) {
            this.effectiveLevelInt = newParentLevel.levelInt;
            if (this.childrenList != null) {
                int len = this.childrenList.size();
                for (int i = 0; i < len; ++i) {
                    Logger child = this.childrenList.get(i);
                    child.handleParentLevelChange(newParentLevel);
                }
            }
        }
    }

    public synchronized void detachAndStopAllAppenders() {
        if (this.aai != null) {
            this.aai.detachAndStopAllAppenders();
        }
    }

    public synchronized Appender<LoggingEvent> detachAppender(String name) {
        if (this.aai == null) {
            return null;
        }
        return this.aai.detachAppender(name);
    }

    public synchronized void addAppender(Appender<LoggingEvent> newAppender) {
        if (this.aai == null) {
            this.aai = new AppenderAttachableImpl();
        }
        this.aai.addAppender(newAppender);
    }

    public boolean isAttached(Appender appender) {
        if (this.aai == null) {
            return false;
        }
        return this.aai.isAttached(appender);
    }

    public synchronized Iterator iteratorForAppenders() {
        if (this.aai == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.aai.iteratorForAppenders();
    }

    public Appender<LoggingEvent> getAppender(String name) {
        if (this.aai == null) {
            return null;
        }
        return this.aai.getAppender(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAppenders(LoggingEvent event) {
        int writes = 0;
        Logger l = this;
        while (l != null) {
            Logger logger = l;
            synchronized (logger) {
                writes += l.appendLoopOnAppenders(event);
                if (!l.additive) {
                    break;
                }
            }
            l = l.parent;
        }
        if (writes == 0) {
            this.loggerContext.noAppenderDefinedWarning(this);
        }
    }

    private int appendLoopOnAppenders(LoggingEvent event) {
        int size = 0;
        if (this.aai != null) {
            size = this.aai.appendLoopOnAppenders((Object)event);
        }
        return size;
    }

    public synchronized boolean detachAppender(Appender appender) {
        if (this.aai == null) {
            return false;
        }
        return this.aai.detachAppender(appender);
    }

    Logger createChildByLastNamePart(String lastPart) {
        int i_index = lastPart.indexOf(46);
        if (i_index != -1) {
            throw new IllegalArgumentException("Child name [" + lastPart + " passed as parameter, may not include [" + '.' + "]");
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Logger>();
        }
        Logger childLogger = this.isRootLogger() ? new Logger(lastPart, this, this.loggerContext) : new Logger(this.name + '.' + lastPart, this, this.loggerContext);
        this.childrenList.add(childLogger);
        childLogger.effectiveLevelInt = this.effectiveLevelInt;
        return childLogger;
    }

    void recursiveReset() {
        this.detachAndStopAllAppenders();
        this.additive = true;
        if (this.childrenList == null) {
            return;
        }
        for (Logger childLogger : this.childrenList) {
            childLogger.recursiveReset();
        }
    }

    Logger createChildByName(String childName) {
        int i_index = childName.indexOf(46, this.name.length() + 1);
        if (i_index != -1) {
            throw new IllegalArgumentException("For logger [" + this.name + "] child name [" + childName + " passed as parameter, may not include '.' after index" + (this.name.length() + 1));
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Logger>(5);
        }
        Logger childLogger = new Logger(childName, this, this.loggerContext);
        this.childrenList.add(childLogger);
        childLogger.effectiveLevelInt = this.effectiveLevelInt;
        return childLogger;
    }

    public void debug(String msg) {
        this.filterAndLog(null, Level.DEBUG, msg, null, null);
    }

    public void debug(String format, Object arg) {
        this.filterAndLog(null, Level.DEBUG, format, new Object[]{arg}, null);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.filterAndLog(null, Level.DEBUG, format, new Object[]{arg1, arg2}, null);
    }

    public void debug(String format, Object[] argArray) {
        this.filterAndLog(null, Level.DEBUG, format, argArray, null);
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(null, Level.DEBUG, msg, null, t);
        }
    }

    public final void debug(Marker marker, String msg) {
        this.filterAndLog(marker, Level.DEBUG, msg, null, null);
    }

    public final void filterAndLog(String localFQCN, Marker marker, Level level, String msg, Object[] params, Throwable t) {
        FilterReply decision = this.loggerContext.getTurboFilterChainDecision(marker, this, Level.DEBUG, msg, params, t);
        if (decision == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : decision == FilterReply.DENY) {
            return;
        }
        LoggingEvent le = new LoggingEvent(localFQCN, this, level, msg, t, params);
        le.setMarker(marker);
        this.callAppenders(le);
    }

    final void filterAndLog(Marker marker, Level level, String msg, Object[] params, Throwable t) {
        this.filterAndLog(FQCN, marker, level, msg, params, t);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.filterAndLog(marker, Level.DEBUG, format, new Object[]{arg}, null);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.filterAndLog(marker, Level.DEBUG, format, new Object[]{arg1, arg2}, null);
    }

    public void debug(Marker marker, String format, Object[] argArray) {
        this.filterAndLog(marker, Level.DEBUG, format, argArray, null);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.filterAndLog(marker, Level.DEBUG, msg, null, t);
    }

    public void error(String msg) {
        this.filterAndLog(null, Level.ERROR, msg, null, null);
    }

    public void error(String format, Object arg) {
        this.filterAndLog(null, Level.ERROR, format, new Object[]{arg}, null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.filterAndLog(null, Level.ERROR, format, new Object[]{arg1, arg2}, null);
    }

    public void error(String format, Object[] argArray) {
        this.filterAndLog(null, Level.ERROR, format, argArray, null);
    }

    public void error(String msg, Throwable t) {
        this.filterAndLog(null, Level.ERROR, msg, null, t);
    }

    public void error(Marker marker, String msg) {
        this.filterAndLog(marker, Level.ERROR, msg, null, null);
    }

    public void error(Marker marker, String format, Object arg) {
        this.filterAndLog(marker, Level.ERROR, format, new Object[]{arg}, null);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.filterAndLog(marker, Level.ERROR, format, new Object[]{arg1, arg2}, null);
    }

    public void error(Marker marker, String format, Object[] argArray) {
        this.filterAndLog(marker, Level.ERROR, format, argArray, null);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.filterAndLog(marker, Level.ERROR, msg, null, t);
    }

    public void info(String msg) {
        this.filterAndLog(null, Level.INFO, msg, null, null);
    }

    public void info(String format, Object arg) {
        this.filterAndLog(null, Level.INFO, format, new Object[]{arg}, null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.filterAndLog(null, Level.INFO, format, new Object[]{arg1, arg2}, null);
    }

    public void info(String format, Object[] argArray) {
        this.filterAndLog(null, Level.INFO, format, argArray, null);
    }

    public void info(String msg, Throwable t) {
        this.filterAndLog(null, Level.INFO, msg, null, t);
    }

    public void info(Marker marker, String msg) {
        this.filterAndLog(marker, Level.INFO, msg, null, null);
    }

    public void info(Marker marker, String format, Object arg) {
        this.filterAndLog(marker, Level.INFO, format, new Object[]{arg}, null);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.filterAndLog(marker, Level.INFO, format, new Object[]{arg1, arg2}, null);
    }

    public void info(Marker marker, String format, Object[] argArray) {
        this.filterAndLog(marker, Level.INFO, format, argArray, null);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.filterAndLog(marker, Level.INFO, msg, null, t);
    }

    public final boolean isDebugEnabled() {
        return this.effectiveLevelInt <= 10000;
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public final boolean isErrorEnabled() {
        return this.effectiveLevelInt <= 40000;
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.effectiveLevelInt <= 20000;
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.effectiveLevelInt <= 30000;
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public boolean isEnabledFor(Level level) {
        return this.effectiveLevelInt <= level.levelInt;
    }

    public void warn(String msg) {
        this.filterAndLog(null, Level.WARN, msg, null, null);
    }

    public void warn(String msg, Throwable t) {
        this.filterAndLog(null, Level.WARN, msg, null, t);
    }

    public void warn(String format, Object arg) {
        this.filterAndLog(null, Level.WARN, format, new Object[]{arg}, null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.filterAndLog(null, Level.WARN, format, new Object[]{arg1, arg2}, null);
    }

    public void warn(String format, Object[] argArray) {
        this.filterAndLog(null, Level.WARN, format, argArray, null);
    }

    public void warn(Marker marker, String msg) {
        this.filterAndLog(marker, Level.WARN, msg, null, null);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.filterAndLog(marker, Level.WARN, format, new Object[]{arg}, null);
    }

    public void warn(Marker marker, String format, Object[] argArray) {
        this.filterAndLog(marker, Level.WARN, format, argArray, null);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.filterAndLog(marker, Level.WARN, format, new Object[]{arg1, arg2}, null);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.filterAndLog(marker, Level.WARN, msg, null, t);
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public String toString() {
        return "Logger[" + this.name + "]";
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    public LoggerRemoteView getLoggerRemoteView() {
        return this.loggerRemoteView;
    }

    void buildRemoteView() {
        this.loggerRemoteView = new LoggerRemoteView(this.name, this.loggerContext);
    }
}

