/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.MockSyslogServer;
import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import junit.framework.TestCase;

public class SyslogAppenderTest
extends TestCase {
    public SyslogAppenderTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBasic() throws InterruptedException {
        int port = 14501;
        MockSyslogServer mockServer = new MockSyslogServer(1, port);
        mockServer.start();
        Thread.sleep(100L);
        LoggerContext lc = new LoggerContext();
        lc.setName("test");
        SyslogAppender sa = new SyslogAppender();
        sa.setContext((Context)lc);
        sa.setSyslogHost("localhost");
        sa.setFacility("MAIL");
        sa.setPort(port);
        sa.setSuffixPattern("[%thread] %logger %msg");
        sa.start();
        SyslogAppenderTest.assertTrue((boolean)sa.isStarted());
        String loggerName = ((Object)((Object)this)).getClass().getName();
        Logger logger = lc.getLogger(loggerName);
        logger.addAppender((Appender)sa);
        String logMsg = "hello";
        logger.debug(logMsg);
        mockServer.join(8000L);
        SyslogAppenderTest.assertTrue((boolean)mockServer.finished);
        SyslogAppenderTest.assertEquals((int)1, (int)mockServer.msgList.size());
        String msg = mockServer.msgList.get(0);
        String expected = "<23>";
        SyslogAppenderTest.assertTrue((boolean)msg.startsWith(expected));
        String first = "<\\d{2}>\\w{3} \\d{2} \\d{2}(:\\d{2}){2} \\w* ";
        String threadName = Thread.currentThread().getName();
        SyslogAppenderTest.assertTrue((boolean)msg.matches(first + "\\[" + threadName + "\\] " + loggerName + " " + logMsg));
    }

    public void testException() throws InterruptedException {
        int port = 14502;
        MockSyslogServer mockServer = new MockSyslogServer(21, port);
        mockServer.start();
        Thread.sleep(100L);
        LoggerContext lc = new LoggerContext();
        lc.setName("test");
        SyslogAppender sa = new SyslogAppender();
        sa.setContext((Context)lc);
        sa.setSyslogHost("localhost");
        sa.setFacility("MAIL");
        sa.setPort(port);
        sa.setSuffixPattern("[%thread] %logger %msg");
        sa.start();
        SyslogAppenderTest.assertTrue((boolean)sa.isStarted());
        String loggerName = ((Object)((Object)this)).getClass().getName();
        Logger logger = lc.getLogger(loggerName);
        logger.addAppender((Appender)sa);
        String logMsg = "hello";
        String exMsg = "just testing";
        Exception ex = new Exception(exMsg);
        logger.debug(logMsg, (Throwable)ex);
        mockServer.join(8000L);
        SyslogAppenderTest.assertTrue((boolean)mockServer.finished);
        SyslogAppenderTest.assertEquals((int)21, (int)mockServer.msgList.size());
        String msg = mockServer.msgList.get(0);
        String expected = "<23>";
        SyslogAppenderTest.assertTrue((boolean)msg.startsWith(expected));
        String expectedPrefix = "<\\d{2}>\\w{3} \\d{2} \\d{2}(:\\d{2}){2} \\w* ";
        String threadName = Thread.currentThread().getName();
        String expectedResult = expectedPrefix + "\\[" + threadName + "\\] " + loggerName + " " + logMsg;
        SyslogAppenderTest.assertTrue((boolean)msg.matches(expectedResult));
    }
}

