/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.BasicConfigurator;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.core.Appender;
import java.io.InputStreamReader;
import org.slf4j.LoggerFactory;

public class SocketMin {
    static Logger logger = (Logger)LoggerFactory.getLogger((String)SocketMin.class.getName());
    static SocketAppender s;

    public static void main(String[] argv) {
        if (argv.length == 3) {
            SocketMin.init(argv[0], argv[1]);
        } else {
            SocketMin.usage("Wrong number of arguments.");
        }
        if (argv[2].equals("true")) {
            SocketMin.loop();
        } else {
            SocketMin.test();
        }
        s.stop();
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + SocketMin.class + " host port true|false");
        System.exit(1);
    }

    static void init(String host, String portStr) {
        Logger root = (Logger)LoggerFactory.getLogger((String)"root");
        BasicConfigurator.configure((LoggerContext)root.getLoggerContext());
        try {
            int port = Integer.parseInt(portStr);
            logger.info("Creating socket appender (" + host + "," + port + ").");
            s = new SocketAppender(host, port);
            s.setName("S");
            root.addAppender((Appender)s);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            SocketMin.usage("Could not interpret port number [" + portStr + "].");
        }
        catch (Exception e) {
            System.err.println("Could not start!");
            e.printStackTrace();
            System.exit(1);
        }
    }

    static void loop() {
        Logger root = (Logger)LoggerFactory.getLogger((String)"root");
        InputStreamReader in = new InputStreamReader(System.in);
        System.out.println("Type 'q' to quit");
        int k = 0;
        while (true) {
            int i;
            logger.debug("Message " + k++);
            logger.info("Message " + k++);
            logger.warn("Message " + k++);
            logger.error("Message " + k++, (Throwable)new Exception("Just testing"));
            try {
                i = in.read();
            }
            catch (Exception e) {
                return;
            }
            if (i == -1 || i == 113) break;
            if (i != 114) continue;
            System.out.println("Removing appender S");
            root.detachAppender("S");
        }
    }

    static void test() {
        int i = 0;
        logger.debug("Message " + i++);
        logger.info("Message " + i++);
        logger.warn("Message " + i++);
        logger.error("Message " + i++);
        logger.debug("Message " + i++, (Throwable)new Exception("Just testing."));
    }
}

